/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.diagnostic;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.mbean.MBeanInvocationHandler;
import de.qtc.beanshooter.mbean.diagnostic.DiagnosticCommandMBean;
import de.qtc.beanshooter.mbean.diagnostic.DiagnosticCommandOption;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.management.MBeanException;

public class Dispatcher
extends de.qtc.beanshooter.mbean.Dispatcher {
    private final DiagnosticCommandMBean diagnostic;

    public Dispatcher() {
        super(MBean.DIAGNOSTIC_COMMAND);
        MBeanInvocationHandler invo = new MBeanInvocationHandler(this.bean.getObjectName(), this.getMBeanServerConnection());
        this.diagnostic = (DiagnosticCommandMBean)Proxy.newProxyInstance(Dispatcher.class.getClassLoader(), new Class[]{DiagnosticCommandMBean.class}, (InvocationHandler)invo);
    }

    public void readFile() {
        String filename = (String)ArgumentHandler.require(DiagnosticCommandOption.FILENAME);
        try {
            String output = this.diagnostic.compilerDirectivesAdd(new String[]{filename});
            if (DiagnosticCommandOption.RAW.getBool()) {
                Logger.printlnPlainBlue(output.trim());
            } else if (output.startsWith("Could not load file")) {
                Logger.eprintlnMixedBlue("The server was unable to open the file", filename);
                Logger.eprintln("This could mean that the file does not exist, is a directory or the sever is missing permissions.");
            } else if (output.startsWith("Syntax error on line") && output.contains(" At '")) {
                output = output.substring(output.indexOf(10) + 1);
                output = output.substring(output.indexOf(10) + 1);
                int endIndex = output.indexOf("Parsing of compiler directives failed");
                Logger.printlnPlainBlue(output.substring(0, endIndex).trim());
            } else {
                Logger.printlnPlainBlue(output.trim());
            }
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "calling", "compilerDirectivesAdd", true);
        }
    }

    public void loadLibrary() {
        String filename = (String)ArgumentHandler.require(DiagnosticCommandOption.LIBRARY_PATH);
        try {
            String output = this.diagnostic.jvmtiAgentLoad(new String[]{filename});
            if (output.contains("No such file or directory")) {
                Logger.eprintlnMixedBlue("The server was unable to find the shared library", filename);
            } else if (output.contains("Is a directory")) {
                Logger.eprintlnMixedBlue("The specified filename", filename, "is a directory.");
            } else if (output.contains("Agent_OnAttach is not available in")) {
                Logger.printlnMixedBlue("The server complained about the missing function", "Agent_OnAttach");
                Logger.printlnYellow("The specified library was loaded succesfully.");
            } else {
                Logger.printlnBlue(output.trim());
            }
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "calling", "jvmtiAgentLoad", true);
        }
    }

    public void setLogfile() {
        String filename = (String)ArgumentHandler.require(DiagnosticCommandOption.FILENAME);
        try {
            String output = this.diagnostic.vmLog(new String[]{"output=" + filename});
            if (output.contains("No such file or directory")) {
                Logger.eprintlnMixedBlue("The server was unable to write to", filename);
            } else if (output.contains("Is a directory")) {
                Logger.eprintlnMixedBlue("The specified filename", filename, "is a directory.");
            } else if (output.isEmpty()) {
                Logger.printlnMixedBlue("Logfile path was successfully set to", filename);
            } else {
                Logger.printlnBlue(output.trim());
            }
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "calling", "vmLog", true);
        }
    }

    public void disableLogging() {
        try {
            String output = this.diagnostic.vmLog(new String[]{"disable"});
            if (output.isEmpty()) {
                Logger.printlnBlue("Logging was disabled successfully.");
            } else {
                Logger.eprintlnBlue(output.trim());
            }
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "calling", "vmLog", true);
        }
    }

    public void getCommandLine() {
        try {
            Logger.printlnPlainBlue(this.diagnostic.vmCommandLine().trim());
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "calling", "vmCommandline", true);
        }
    }

    public void getSystemProperties() {
        try {
            Logger.printlnPlainBlue(this.diagnostic.vmSystemProperties().trim());
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "calling", "vmSystemProperties", true);
        }
    }
}

