/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean;

import de.qtc.beanshooter.cli.Operation;
import de.qtc.beanshooter.cli.Option;
import de.qtc.beanshooter.cli.OptionHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.mbean.Dispatcher;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.operation.BeanshooterOption;
import java.lang.reflect.Method;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public enum MBeanOperation implements Operation
{
    ATTR("attr", "set or get MBean attributes", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_SASL, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.ATTR_ATTRIBUTE, BeanshooterOption.ATTR_VALUE, BeanshooterOption.ATTR_TYPE}),
    DEPLOY("deploy", "deploys the specified MBean on the JMX server", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, BeanshooterOption.DEPLOY_NO_STAGER, BeanshooterOption.DEPLOY_STAGER_URL, BeanshooterOption.DEPLOY_STAGER_PORT, BeanshooterOption.DEPLOY_STAGER_ADDR}),
    EXPORT("export", "create an export of the MBean", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.EXPORT_DIR, BeanshooterOption.EXPORT_JAR, BeanshooterOption.EXPORT_MLET, BeanshooterOption.EXPORT_URL}),
    INFO("info", "print server information about the MBean", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, BeanshooterOption.ATTR_WRITEABLE, BeanshooterOption.ATTR_HARVEST, BeanshooterOption.ATTR_KEYWORDS}),
    INVOKE("invoke", "invoke the specified method on the MBean", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, BeanshooterOption.INVOKE_METHOD_ARGS, BeanshooterOption.INVOKE_METHOD, BeanshooterOption.INVOKE_NO_WRAP}),
    STATS("stats", "print local information about the MBean", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE}),
    STATUS("status", "checks whether the MBean is registered", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL}),
    UNDEPLOY("undeploy", "undeploys the specified MBEAN from the JMX server", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL});

    private Method method;
    private String description;
    private Option[] options;
    private Dispatcher dispatcher;
    private static MBean currentBean;

    private MBeanOperation(String methodName, String description, Option[] options) {
        try {
            this.method = Dispatcher.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            ExceptionHandler.internalException(e, "Operation constructor", true);
        }
        this.description = description;
        this.options = options;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean containsOption(Option option) {
        for (Option o : this.options) {
            if (o != option) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invoke() {
        if (currentBean == null) {
            ExceptionHandler.internalError("Operation.invoke(...)", "currentBean was not set");
        }
        if (this.dispatcher == null) {
            this.dispatcher = new Dispatcher(currentBean);
        }
        try {
            this.method.invoke((Object)this.dispatcher, new Object[0]);
        }
        catch (Exception e) {
            ExceptionHandler.internalException(e, "Operation.invoke(...)", true);
        }
    }

    public static void setMBean(MBean bean) {
        currentBean = bean;
    }

    public static Operation getByName(String name) {
        Operation returnItem = null;
        if (currentBean != null) {
            for (Operation operation : currentBean.getOperations()) {
                if (!operation.toString().equalsIgnoreCase(name)) continue;
                returnItem = operation;
                break;
            }
        }
        for (Operation operation : MBeanOperation.values()) {
            if (!operation.toString().equalsIgnoreCase(name)) continue;
            returnItem = operation;
            break;
        }
        return returnItem;
    }

    public static void addSubparsers(Subparsers argumentParser) {
        for (MBean bean : MBean.values()) {
            Subparser opParser;
            Subparser parser = argumentParser.addParser(bean.getName()).help(bean.getDescription());
            Subparsers subparsers = parser.addSubparsers().help(" ").metavar(" ").dest("mbean-action");
            for (Operation operation : bean.getOperations()) {
                if (operation.getName().equals("ENUM")) continue;
                opParser = subparsers.addParser(operation.getName().toLowerCase()).help(operation.getDescription());
                OptionHandler.addOptions(operation, opParser);
            }
            for (Operation operation : MBeanOperation.values()) {
                if (((MBeanOperation)operation).getName().equals("EXPORT") && bean.getJarName() == null) continue;
                opParser = subparsers.addParser(((MBeanOperation)operation).getName().toLowerCase()).help(((MBeanOperation)operation).getDescription());
                OptionHandler.addOptions(operation, opParser);
            }
        }
    }
}

