/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean;

import de.qtc.beanshooter.cli.Operation;
import de.qtc.beanshooter.cli.Option;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.IMBean;
import de.qtc.beanshooter.mbean.diagnostic.DiagnosticCommandOperation;
import de.qtc.beanshooter.mbean.diagnostic.DiagnosticCommandOption;
import de.qtc.beanshooter.mbean.flightrecorder.FlightRecorderOperation;
import de.qtc.beanshooter.mbean.flightrecorder.FlightRecorderOption;
import de.qtc.beanshooter.mbean.hotspot.HotSpotDiagnosticOperation;
import de.qtc.beanshooter.mbean.hotspot.HotSpotDiagnosticOption;
import de.qtc.beanshooter.mbean.mlet.MLetOperation;
import de.qtc.beanshooter.mbean.mlet.MLetOption;
import de.qtc.beanshooter.mbean.tomcat.MemoryUserDatabaseMBeanOperation;
import de.qtc.beanshooter.mbean.tomcat.MemoryUserDatabaseMBeanOption;
import de.qtc.beanshooter.mbean.tonkabean.TonkaBeanOperation;
import de.qtc.beanshooter.mbean.tonkabean.TonkaBeanOption;
import de.qtc.beanshooter.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public enum MBean implements IMBean
{
    DIAGNOSTIC_COMMAND("diagnostic", "Diagnostic Command MBean", Utils.getObjectName("com.sun.management:type=DiagnosticCommand"), new String[]{"com.sun.management.internal.DiagnosticCommandImpl", "sun.management.DiagnosticCommandImpl"}, null, DiagnosticCommandOperation.values(), DiagnosticCommandOption.values()),
    HOTSPOT_DIAGNOSTIC("hotspot", "HotSpot Diagnostic MBean", Utils.getObjectName("com.sun.management:type=HotSpotDiagnostic"), new String[]{"com.sun.management.internal.HotSpotDiagnostic", "sun.management.HotSpotDiagnostic"}, null, HotSpotDiagnosticOperation.values(), HotSpotDiagnosticOption.values()),
    MLET("mlet", "default JMX bean that can be used to load additional beans dynamically", Utils.getObjectName("DefaultDomain:type=MLet"), new String[]{"javax.management.loading.MLet"}, null, MLetOperation.values(), MLetOption.values()),
    FLIGHT_RECORDER("recorder", "jfr Flight Recorder MBean", Utils.getObjectName("jdk.management.jfr:type=FlightRecorder"), new String[]{"jdk.management.jfr.FlightRecorderMXBeanImpl"}, null, FlightRecorderOperation.values(), FlightRecorderOption.values()),
    MEMORY_USER_DATABASE("tomcat", "tomcat MemoryUserDatabaseMBean used for user management", Utils.getObjectName("Users:type=UserDatabase,database=UserDatabase"), new String[]{"org.apache.catalina.mbeans.MemoryUserDatabaseMBean"}, null, MemoryUserDatabaseMBeanOperation.values(), MemoryUserDatabaseMBeanOption.values()),
    TONKA("tonka", "general purpose bean for executing commands and uploading or download files", Utils.getObjectName("MLetTonkaBean:name=TonkaBean,id=1"), new String[]{"de.qtc.beanshooter.tonkabean.TonkaBean"}, "tonka-bean-4.1.0-jar-with-dependencies.jar", TonkaBeanOperation.values(), TonkaBeanOption.values());

    private String name;
    private String description;
    private ObjectName objectName;
    private String[] mBeanClasses;
    private String jarFileName;
    private Operation[] operations;
    private Option[] options;

    private MBean(String name, String description, ObjectName objName, String[] mBeanClasses, String jarName, Operation[] operations, Option[] options) {
        this.name = name;
        this.description = description;
        this.operations = operations;
        this.objectName = objName;
        this.mBeanClasses = mBeanClasses;
        this.jarFileName = jarName;
        this.options = options;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getMBeanClass() {
        return this.mBeanClasses[0];
    }

    @Override
    public String getJarName() {
        return this.jarFileName;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public static MBean getMBean(String beanName) {
        MBean returnValue = null;
        for (MBean bean : MBean.values()) {
            if (!bean.name.equals(beanName)) continue;
            returnValue = bean;
        }
        return returnValue;
    }

    public static MBean getMBean(ObjectName objectName) {
        MBean returnValue = null;
        for (MBean bean : MBean.values()) {
            if (!bean.objectName.equals(objectName)) continue;
            returnValue = bean;
        }
        return returnValue;
    }

    public static List<String> getBeanNames() {
        ArrayList<String> mBeanNames = new ArrayList<String>();
        for (MBean bean : MBean.values()) {
            mBeanNames.add(bean.getName());
        }
        return mBeanNames;
    }

    public static List<String> getBeanClasses() {
        ArrayList<String> mBeanNames = new ArrayList<String>();
        for (MBean bean : MBean.values()) {
            for (String className : bean.mBeanClasses) {
                mBeanNames.add(className);
            }
        }
        return mBeanNames;
    }

    public static List<String> getLoadableBeanNames() {
        ArrayList<String> mBeanNames = new ArrayList<String>();
        for (MBean bean : MBean.values()) {
            if (bean.jarFileName == null) continue;
            mBeanNames.add(bean.getName());
        }
        return mBeanNames;
    }

    public static void performEnumActions(Set<ObjectInstance> instances) {
        for (ObjectInstance instance : instances) {
            MBean mbean = MBean.getMBean(instance.getObjectName());
            if (mbean == null) continue;
            for (Operation op : mbean.getOperations()) {
                if (!op.getName().equals("ENUM")) continue;
                Logger.lineBreak();
                op.invoke();
            }
        }
    }
}

