/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.io;

import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class WordlistHandler {
    private static final String defaultWordlist = "/default-credentials.txt";

    public static Map<String, Set<String>> getCredentialMap() {
        String[] usernames = null;
        String[] passwords = null;
        if (BeanshooterOption.BRUTE_USER.notNull()) {
            usernames = new String[]{(String)BeanshooterOption.BRUTE_USER.getValue()};
        } else if (BeanshooterOption.BRUTE_USER_FILE.notNull()) {
            usernames = WordlistHandler.readWordlist((String)BeanshooterOption.BRUTE_USER_FILE.getValue(), "user");
        }
        if (BeanshooterOption.BRUTE_PASSWORD.notNull()) {
            passwords = new String[]{(String)BeanshooterOption.BRUTE_PASSWORD.getValue()};
        } else if (BeanshooterOption.BRUTE_PW_FILE.notNull()) {
            passwords = WordlistHandler.readWordlist((String)BeanshooterOption.BRUTE_PW_FILE.getValue(), "password");
        }
        if (usernames == null && passwords != null) {
            Logger.eprintlnMixedYellowFirst("No username(s)", "specified for the brute action.");
            Utils.exit();
        } else if (usernames != null && passwords == null) {
            Logger.eprintlnMixedYellowFirst("No password(s)", "specified for the brute action.");
            Utils.exit();
        } else if (usernames != null && passwords != null) {
            return WordlistHandler.makeMap(usernames, passwords);
        }
        return WordlistHandler.readCredpairList();
    }

    private static String[] readWordlist(String filename, String type) {
        Logger.printlnMixedBlue(String.format("Reading %s wordlist:", type), filename);
        try {
            return new String(Utils.readFile(filename)).split("\n");
        }
        catch (IOException e) {
            ExceptionHandler.handleFileRead(e, filename, true);
            return new String[0];
        }
    }

    private static Map<String, Set<String>> readCredpairList() {
        Logger.printlnBlue("Reading credentials from internal wordlist.");
        HashMap<String, Set<String>> bruteMap = new HashMap<String, Set<String>>();
        try {
            InputStream stream = WordlistHandler.class.getResourceAsStream(defaultWordlist);
            String content = new String(IOUtils.toByteArray(stream));
            stream.close();
            for (String line : content.split("\n")) {
                String[] split = line.split(":");
                if (split.length != 2) {
                    throw new IOException("Invalid credential file!");
                }
                if (bruteMap.containsKey(split[0])) {
                    ((Set)bruteMap.get(split[0])).add(split[1]);
                    continue;
                }
                HashSet<String> passwords = new HashSet<String>();
                passwords.add(split[1]);
                bruteMap.put(split[0], passwords);
            }
        }
        catch (IOException e) {
            ExceptionHandler.unexpectedException(e, "reading", "internal wordlist", true);
        }
        return bruteMap;
    }

    private static Map<String, Set<String>> makeMap(String[] usernames, String[] passwords) {
        HashMap<String, Set<String>> bruteMap = new HashMap<String, Set<String>>();
        for (String username : usernames) {
            bruteMap.put(username, new HashSet<String>(Arrays.asList(passwords)));
        }
        return bruteMap;
    }
}

