# Ankara Yildirim Beyazit University Computer Engineering Department

## CENG 325 - Principles of Information Security And Privacy

<a href="http://aybu.edu.tr"><img src="https://pbs.twimg.com/profile_images/746983711665709056/IqO2q_wg_400x400.jpg" title="CENG201 OOP Project" alt="CENG201 OOP Project" width=200 height=200></a>

**Group Members**

<a href="https://github.com/canumay" target="_blank">**@canumay**</a>
<a href="https://github.com/aslihann" target="_blank">**@aslihann**</a>
<a href="https://github.com/ezgigucuyener" target="_blank">**@ezgigucuyener**</a>
<a href="https://github.com/mburakdonmez" target="_blank">**@mburakdonmez**</a>

**References**

[NVD - CVE-2018-1335](https://nvd.nist.gov/vuln/detail/CVE-2018-1335)

[Exploit DB - Apache Tika-server < 1.18 - Command Injection](https://www.exploit-db.com/exploits/46540)

[Rhino Security Labs - Exploiting CVE-2018-1335: Command Injection in Apache Tika](https://rhinosecuritylabs.com/application-security/exploiting-cve-2018-1335-apache-tika/)

[Metasploit](https://github.com/rapid7/metasploit-framework)

**Disclaimer**

*The exploit code is written by Cyber Security Researcher <a href="https://twitter.com/Daveysec" target="_blank">David Yesland @Daveysec</a> and should be using for educational purposes.*

### Milestone 1 – Vulnerability Research

**a. A brief description of the vulnerability**

- **The type**: Command Injection
- **The impact factor**: The impact score of the vulnerability is 5.9 according to CVSS impact metrics. All three of confidentiality, integrity and availability are high.
- **The severity score**: The severity score of the vulnerability is 8.1 according to CVSS base score metrics. (CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H)
- **Affected versions of vulnerable application**: From Apache Tika versions 1.7 to 1.17
- **What does it mean the type of the vulnerability**
  - **Introduce the type of the vulnerability and discuss why it is different from the other type of vulnerabilities**
    The vulnerability type is command injection. It is because vulnerable applications
    pass unsanitized user data to the system shell which allows malicious code to be
    executed. If we compare this vulnerability with code injection, we determine
    some differences. For example, code injection allows the attacker to use their
    own code which is executed by the application. But with command injection, the
    attacker modifies the functionality of the application, which allows users to run
    system commands

**b. The way of exploiting the vulnerability**

- **What type of attacks can be implement after triggering the vulnerability**: After
  triggering the vulnerability we can easily create a reverse shell, and with that shell we
  can basically execute all commands that is available to the user running the apache tika
  server.

- **How does an attacker exploit vulnerable systems using the vulnerability**: Firstly,
  attacker should determine if the server is running vulnerable version of the apache tika
  server. Then the attacker generates a malicious HTTP header and the Jscript code before
  sending a PUT request to the vulnerable HTTP end point which causes the apache tika
  server to execute the malicious code using its own functionality.

- **Is the vulnerability used in exploit kits**: Yes, this vulnerability is available in
  Metasploit exploit kit.

### Milestone 2 – Exploit Code

**a. Find or craft an exploit code that exploits the vulnerability**

<img src="./images/code.png" />

**b. Highlight the vulnerable code pieces and explain why they are vulnerable**

<img src="./images/vulnerable_code1.png" />

The apache tika server crafts a command to execute, with the values provided by the user in the
request to run OCR on images. This allows for users to manipulate with the command and execute
malicious code. In this case the “config.getTesseractPath()” fetches the “X-Tika-OCRTesseractPath”
header and adds it to the beginning of the command. Although the “tesseract.exe” string is added
to the end of the user provided path, user can wrap their path with ‘ “ ’ (double quotes) to discard
the following “tesseract.exe” string. This allows for user to run any executable in the server.

The crafted command:

```sh
"calc.exe"tesseract.exe C:\Users\Test\AppData\Local\Temp\apache-tika3299124493942985299.tmp C:\Users\Test\AppData\Local\Temp\apache-tika7317860646082338953.tmp -l eng -psm 1 txt -c preserve_interword_spaces=0
```

The CScript.exe built into the windows is a scripting language which takes a filename for a script
and run it and ignores the other arguments. If we can provide a script built for the cscript, we can
execute it in the server. The apache tika server takes our image provided in the body and saves it to a
temporary file to run the OCR, so instead of sending an image binary we can directly send a string and
the string will be saved as if it was a binary. But the tika server checks for the binary if it is an image
except for the jp2 file type, in which case it is saved directly. Which will be passed as an argument to
the cscript executable. But the file extension will still be “.tmp”, but we need a “. JScript” or “.vbs”. In
order to pass this, we can say the cscript to run “JScript” no matter what the file extension is. The tika
server also passes the “config.getPageSetMode()” to the command which is sent by user in X-TikaOCRLanguage” header. 
If we change it with the string “//E:Jscript” the cscript will run the script as
JScript no matter what the file extension is. And finally, the string provided in the body will be the
payload to be executed, which can also call another console to have full access to the system shell.

The final crafted command:

```sh
"cscript.exe"tesseract.exe C:\Users\Test\AppData\Local\Temp\apache-tika3299124493942985299.tmp C:\Users\Test\AppData\Local\Temp\apache-tika7317860646082338953.tmp -l //E:Jscript -psm 1 txt -c preserve_interword_spaces=0
```

A simple payload to call shell in Jscript:


```sh
var oShell = WScript.CreateObject("WScript.Shell");
var oExec = oShell.Exec('cmd /c calc.exe');
```


### Milestone 3 – The Execution

**a. Execute the exploit code you find or craft:**

<img src="./images/1.png" />

Apache Tika Server 1.17 is running inside of the target virtual machine.


<img src="./images/2.png" />

We can access the server from our host machine with the IP “192.168.233.167”.

<img src="./images/3.png" />

Then we executed the crafted exploit code with the payload “calc.exe” to run calculator inside of the target
machine, to show that we have ability to execute any malicious code inside of the target machine. Even also with
the power of reverse shell we can create an interactive shell session on the target machine.

<img src="./images/4.png" />

**b. What are the results of execution of the exploit code:**

As we explained above with this exploit, we basically execute calculator program inside of the
target machine, but with an ability of Remote Code Execution we can do whatever we want in the target
machine with privileges of the user running the Apache Tika Server. For example, we can access user files,
monitor user’s activity and even we can take a screenshot or take a photo with the webcam if exists.

**c. How can you tell that the vulnerability actually exist:**

This vulnerability is already reported by reliable sources like NIST, even confirmed and patched by
Apache itself. But to prove that we can do another PoC using metasploit.

<img src="./images/5.png" />

First, we confirmed that the installed version is a vulnerable version.

<img src="./images/6.png" />

After confirming the version, we can configure our metasploit session with the correct IP and port and run
the “check” command to verify if the target is vulnerable.

<img src="./images/7.png" />

Finally, we can run the “exploit” command to start the exploit and confirm that the shell is live by typing in
“dir” into the shell. From here the only limitation is the user’s privileges running the Apache Tika server.
