<h1 align="center">CVE-2018-11736 PHP RCE Exploit (Pluck CMS)</h1>

> Disclaimer ⚠️: This exploit was developed in Rust primarily as an introductory programming learning exercise. Please excuse any lack of technical rigor or non-idiomatic code patterns. Also, this is not my discovery; I relied on official reports to write this exploit.

PoC exploit for CVE-2018-11736 affecting Pluck CMS versions prior to 4.7.7-dev2. The vulnerability resides in /data/inc/images.php, which allows an attacker to upload arbitrary files. By uploading a malicious .htaccess file disguised with the image/jpeg MIME type, it is possible to coerce the web server into interpreting .jpg files as PHP scripts, leading to arbitrary PHP code execution.

- Attack Prerequisites:
  - Valid cookie session.
  - A .htaccess file that redefines how the server handles .jpg files and a fake image with PHP code. This repository contains an example of both

---

### How to use

You must have Cargo installed to compile main.rs.

```shell
cargo build
```
And a valid authenticated session cookie from the target Pluck CMS instance is required:

```shell
./CVE-2018-11736 -h
CVE-2018-11736 exploit. Uploads a malicious .htaccess to force the web server to interpret .jpg files as PHP scripts, leading to Remote Code Execution (RCE)

Usage: CVE-2018-11736 --cookie <COOKIE> --base-url <BASE_URL> --hta-path <HTACCESS> --image-path <IMAGE>

Options:
  -c, --cookie <COOKIE>      Session Cookie (Once you have logged in succesfully). Format: xxxxxxxxxxxx
  -u, --base-url <BASE_URL>  Base URL (e.g. http://localhost)
  -H, --hta-path <HTACCESS>  Path to the .htaccess file
  -i, --image-path <IMAGE>   Path to the fake image file
  -h, --help                 Print help
  -V, --version              Print version
```

---

### Test the PoC with Docker

To ensure reproducibility and safe testing, a vulnerable instance of Pluck CMS v4.7.4-dev5 can be deployed using Docker. To deploy it, you need to download the .zip of the vulnerable version:

```shell
wget https://github.com/pluck-cms/pluck/archive/refs/tags/4.74-dev5.zip
```

Then, run the next command in the same directory of the docker files:

```shell
docker-compose up -d
```

The web application will be avalaible at http://localhost:8080. If you want to spawn a TTY inside the container:

```shell
docker exec -it pluck-cms bash
```

---

### Demonstration

Here is the PoC in action, demonstrating the upload of the malicious configuration and the RCE.

<div align="center">
  <h4>1. Exploit Execution</h4>
  <img width="800" height="217" alt="snapshot1" src="https://github.com/user-attachments/assets/699c2e9f-15c6-4a69-bef9-ff96d4d39e87" />
  <br><br>

  <h4>2. Server-side Artifacts</h4>
  <img width="500" height="247" alt="snapshot2" src="https://github.com/user-attachments/assets/d3f6ff45-172d-4517-99eb-c26bcdc302fb" />
  <br><br>

  <h4>3. RCE Confirmation</h4>
  <img width="800" height="217" alt="snapshot3" src="https://github.com/user-attachments/assets/94873e54-102b-4fab-a81a-2f397a006559" />
</div>

---

### Secondary Information
- Software & Vendor Link: https://github.com/pluck-cms/pluck
- Version tested: https://github.com/pluck-cms/pluck/archive/refs/tags/4.74-dev5.zip
- Tested on: Ubuntu 24.04 LTS noble
- Date : 2024-10-26
- Original Researcher: [liao10086](https://github.com/liao10086)
- Type: [CWE-434](https://cwe.mitre.org/data/definitions/434.html)
- CVSS 3.x Score: 9.80

---

### References
- https://www.exploit-db.com/exploits/52460
- https://www.cvedetails.com/cve/CVE-2018-11736/
- https://github.com/pluck-cms/pluck/issues/61
