/*
 * Decompiled with CFR 0.152.
 */
package grails.init;

import grails.init.FindReleaseHandler;
import grails.proxy.SystemPropertiesAuthenticator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Start {
    private static final String PROJECT_NAME = "grails-wrapper";
    private static final String BASE_URL = "http://repo.grails.org/grails/core/org/grails/grails-wrapper";
    private static final File WRAPPER_DIR = new File(System.getProperty("user.home") + "/.grails/wrapper");
    private static final File NO_VERSION_JAR = new File(WRAPPER_DIR, "grails-wrapper.jar");

    private static String getVersion() throws SAXException, ParserConfigurationException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            FindReleaseHandler findReleaseHandler = new FindReleaseHandler();
            saxParser.parse(new URL("http://repo.grails.org/grails/core/org/grails/grails-wrapper/maven-metadata.xml").openStream(), (DefaultHandler)findReleaseHandler);
            return findReleaseHandler.getVersion();
        }
        catch (Exception e) {
            if (!NO_VERSION_JAR.exists()) {
                System.out.println("You must be connected to the internet the first time you use the Grails wrapper");
                e.printStackTrace();
                System.exit(1);
            }
            return null;
        }
    }

    private static boolean updateJar(String version) {
        boolean success = false;
        String jarFileName = "grails-wrapper-" + version;
        String jarFileExtension = ".jar";
        WRAPPER_DIR.mkdirs();
        try {
            File dowloadedJar = File.createTempFile(jarFileName, ".jar");
            URL website = new URL("http://repo.grails.org/grails/core/org/grails/grails-wrapper/" + version + "/" + jarFileName + ".jar");
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(dowloadedJar);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            Files.move(dowloadedJar.getAbsoluteFile().toPath(), NO_VERSION_JAR.getAbsoluteFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            success = true;
        }
        catch (Exception e) {
            System.out.println("There was an error downloading the wrapper jar");
            e.printStackTrace();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Authenticator.setDefault(new SystemPropertiesAuthenticator());
        try {
            String version = Start.getVersion();
            if (version != null) {
                Properties props = new Properties();
                File gradleProperties = new File("gradle.properties");
                if (!gradleProperties.exists()) {
                    System.out.println("Could not determine grails wrapper version due to missing gradle.properties file. Using existing jar");
                } else {
                    props.load(new FileInputStream(gradleProperties));
                    String GRAILS_WRAPPER_VERSION = "grailsWrapperVersion";
                    String existingVersion = props.getProperty("grailsWrapperVersion", null);
                    if (!(existingVersion != null && existingVersion.equals(version) && NO_VERSION_JAR.exists() || !Start.updateJar(version))) {
                        try (FileOutputStream outputStream = null;){
                            props.put("grailsWrapperVersion", version);
                            outputStream = new FileOutputStream(gradleProperties);
                            props.store(outputStream, null);
                        }
                    }
                }
            }
            URLClassLoader child = new URLClassLoader(new URL[]{NO_VERSION_JAR.toURI().toURL()});
            Class<?> classToLoad = Class.forName("grails.init.RunCommand", true, child);
            Method main = classToLoad.getMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

