# CVE-2018-1000199

The Linux ptrace code virtualizes access to the debug registers, and
the virtualization code has incorrect error handling.  This means that
if you write an illegal value to, say, DR0, the internal state of the
kernel's breakpoint tracking can become corrupt despite the fact that
the ptrace() call will return -EINVAL.

As a example, you can find the address of do_debug in /proc/kallsyms
on an x86 kernel and pass that address to the attached PoC.  I suspect
that architectures other than x86 are affected as well, but I haven't
tried to exploit it.  The bug itself is spread all over the place in
the kernel in generic and arch code.

I haven't spotted an obvious way to get privilege escalation using
this bug, but it may exist.  For example, it's plausible that using
this bug to target the perf NMI handler could result in overflowing
the NMI stack, resulting in various forms of corruption.  I haven't
tried to analyze the impact on non-x86 architectures since I only know
how x86 breakpoints work, but the effects of the bug could be very
different.

Linus has mostly fixed this upstream in commit
f67b15037a7a50c57f72e69a6d59941ad90a0f0f.  With that commit applied,
the error handling is still wrong but the defect results in a disabled
breakpoint instead of an incorrect breakpoint.

http://man7.org/linux/man-pages/man2/ptrace.2.html

Use Ex:
$ ./PoC.exe ffffffff81b44400
