
# CVE-2017-7184 – Linux Kernel XFRM Privilege Escalation (No Sudo)

## Overview

This repository contains a **proof-of-concept local privilege escalation exploit** for **CVE-2017-7184**, a Linux kernel vulnerability in the **XFRM (IPsec) netlink subsystem**.

The exploit demonstrates how an **unprivileged user** can gain **real root (UID 0)** by:

1. Creating an unprivileged **user + network namespace**
2. Gaining **CAP_NET_ADMIN** inside the namespace
3. Triggering a **kernel stack overflow** in XFRM netlink handling
4. Executing a **kernel ROP chain** to call:

   * `prepare_kernel_cred(NULL)`
   * `commit_creds()`
5. Returning safely to userland with full root privileges

**No sudo is required.**

---

## Vulnerability Details

| Field          | Value                           |
| -------------- | ------------------------------- |
| CVE            | CVE-2017-7184                   |
| Component      | Linux Kernel – XFRM Netlink     |
| Bug Type       | Kernel Stack Overflow           |
| Impact         | Local Privilege Escalation      |
| Attack Vector  | Local (unprivileged user)       |
| Exploit Class  | Namespace abuse + ROP           |
| First Affected | Linux kernels ≤ 4.8             |
| Fixed In       | Kernel patches released in 2017 |

---

## Exploitation Strategy (High-Level)

1. **Unprivileged User Namespace**

   * Uses `unshare(CLONE_NEWUSER | CLONE_NEWNET)`
   * Maps current user → UID 0 inside namespace
   * Grants `CAP_NET_ADMIN` without sudo

2. **XFRM Netlink Abuse**

   * Creates `NETLINK_XFRM` socket
   * Sends malformed `XFRM_MSG_NEWSA` message
   * Triggers kernel stack overflow via oversized attributes

3. **Kernel ROP Execution**

   * Overwrites kernel stack
   * Executes controlled ROP chain
   * Elevates credentials in kernel context

4. **Return to Userland**

   * Uses `swapgs; iretq`
   * Spawns interactive root shell

---

## Requirements

* Vulnerable Linux kernel (tested on **4.8.0-36-generic**)
* `unprivileged_userns_clone = 1`
* Kernel symbols available **or** known offsets
* `gcc` with pthread support

Check namespace support:

```bash
cat /proc/sys/kernel/unprivileged_userns_clone
```

Expected output:

```text
1
```

---

## Compilation

```bash
gcc exploit.c -o exploit -pthread
```

---

## Execution

```bash
./exploit
```

**Do not use sudo.**

If successful, you will obtain a **real root shell**:

```text
uid=0(root) gid=0(root) groups=0(root)
```

---

## Kernel Address Resolution

The exploit attempts to:

1. Leak symbols from `/proc/kallsyms`
2. If restricted, fall back to **hardcoded offsets** for:

   * `commit_creds`
   * `prepare_kernel_cred`
   * kernel base

⚠️ **ROP gadgets and offsets are kernel-version specific.**
You must adjust them for other builds.

---

## Expected Outcomes

### Fully Successful Exploit

* UID = 0
* GID = 0
* Interactive root shell

### Partial Success (Still Vulnerable)

* Namespace creation works
* XFRM socket creation succeeds
* Overflow payload sent
* Kernel crash or no privilege escalation

This still confirms the system is **vulnerable**.

---

## Limitations

* Hardcoded ROP gadgets (kernel-specific)
* No KASLR bypass beyond kallsyms
* No SMEP/SMAP bypass for hardened kernels
* Not reliable on modern kernels

---

## Mitigation

* Update kernel to patched version
* Disable unprivileged user namespaces:

```bash
sysctl -w kernel.unprivileged_userns_clone=0
```

* Enable KASLR, SMEP, SMAP
* Restrict netlink capabilities

---

## Disclaimer

This code is provided **for educational and security research purposes only**.

* Do **not** use on systems you do not own or have permission to test
* The author assumes **no responsibility** for misuse or damage
* Intended for learning kernel exploitation techniques

---

## References

* CVE-2017-7184
* Linux Kernel XFRM Subsystem
* User Namespace Privilege Escalation
* Kernel ROP and `commit_creds` exploitation

