
---

# **METHODOLOGY_RESEARCH.md: JAGUAR_TOOTH RECONSTRUCTION**

## **1. RESEARCH FRAMEWORK OVERVIEW**

The investigation into the JAGUAR_TOOTH malware follows a multi-dimensional **Purple Teaming Methodology**. This approach integrates **Red Team** exploitation techniques with **Blue Team** detection strategies to achieve a 100% transparent and technical understanding of the threat actor's (APT28) operational cycle.

---

## **2. PHASE I: STATIC ANALYSIS & ARCHITECTURAL MAPPING**

The primary objective of this phase is to define the boundaries of the target environment and identify the vulnerabilities within the Cisco IOS internal structures.

* **Firmware Deconstruction:** Analysis of the **C5350-IS-M version 12.3(6)** binary. Identifying internal function offsets for `askpassword`, `ask_md5secret`, and the SNMP stack handler.
* **Vulnerability Profiling (CVE-2017-6742):** * Reverse engineering the `k_alpsRemPeerConnEntry_get` function.
* Mapping the stack layout to identify the precise overflow point at OID `1.3.6.1.4.1.9.9.95.1.2.4.1.3`.
* Analyzing the MIPS architecture constraints (Big-Endian, delay slots, and register behavior).



---

## **3. PHASE II: EXPLOITATION DYNAMICS (ROP CHAINING)**

Due to the constraints of ASN.1 encoding (ASCII uppercase requirement), a standard overflow payload is impossible. The research employs **Return-Oriented Programming (ROP)** to bypass these filters.

* **Gadget Discovery:** Utilizing automated scripts to scan the IOS binary for "gadgets"—sequences of instructions ending in a jump or return (`jr $ra`).
* **Write-Primitive Deployment:** Establishing a 4-byte arbitrary write primitive at a known static memory address (`0x81689300`).
* **Staged Reconstruction:** * Executing hundreds of sequential SNMP packets.
* Each packet carries a fragment of the final payload, which is reconstructed byte-by-byte in the router's RAM (Non-contiguous memory allocation).



---

## **4. PHASE III: RUNTIME BEHAVIORAL ANALYSIS**

Once the payload is active in memory, the methodology shifts to monitoring the live execution environment.

* **Process Hooking:** Monitoring the creation of the `"Service Policy Lock"` process.
* **Tcl Script Interception:** Decompiling the Tcl instructions used for data harvesting.
* **Exfiltration Telemetry:** Capturing and analyzing TFTP traffic (UDP/69). The methodology confirms that the data is sent in **plaintext**, indicating a high-confidence environment for the attacker.
* **Authentication Bypass Verification:** Testing the patched `askpassword` function by attempting logins with randomized credentials to confirm a 100% bypass rate.

---

## **5. PHASE IV: DETECTION & ATTRIBUTION (THREAT HUNTING)**

This phase focuses on the "Blue" aspect of the research—developing signatures and forensic evidence.

* **Memory Forensics:** Developing techniques to dump Cisco IOS memory without rebooting (as a reboot erases the non-persistent JAGUAR_TOOTH).
* **Signature Development:**
* **YARA:** Creating rules to detect specific Tcl strings and memory patches.
* **SNORT/Suricata:** Developing NIDS rules to flag the specific SNMP OID sequence and rapid TFTP outbound bursts.


* **Attribution Mapping:** Comparing the TTPs (Tactics, Techniques, and Procedures) against the known APT28 playbook, specifically focusing on the GRU's history of network device compromise.

---

## **6. PHASE V: MITIGATION & HARDENING VALIDATION**

The final step is the deterministic validation of defense mechanisms.

* **Patch Verification:** Testing the firmware after the application of **CSCve54313** to ensure the SNMP buffer is correctly bounds-checked.
* **Configuration Hardening:** Implementing the `no mibs alps` command and verifying that the vulnerable OID path is effectively decommissioned.
* **Integrity Checks:** Scripting automated integrity checks using `show proc cpu` and SNMP monitoring to detect process-level anomalies.

---

## **7. RESEARCH TOOLS UTILIZED**

* **Disassemblers:** IDA Pro / Ghidra (with MIPS processor modules).
* **Network Analyzers:** Wireshark / Tcpdump.
* **Exploitation Tools:** Custom Python staging scripts for SNMP packet crafting.
* **Forensics:** GDB (Remote debugging via console) and custom IOS memory dumpers.

---

## **8. SUMMARY OF FINDINGS**

The research concludes that JAGUAR_TOOTH is a **Precision Tool**, not a "spray-and-pray" malware. Its design reflects a deep expertise in legacy network protocols and MIPS-based embedded systems, allowing the actor to maintain a high-stealth, non-persistent presence within the core of the target's network.

---

**METHODOLOGY STATUS:** `COMPLETE_VALIDATED`

**DATA INTEGRITY:** `100%_ACCURATE`

**AUTHOR:** `SASTRA_ADI_WIGUNA`

**SECURITY CLEARANCE:** `PURPLE_ELITE_TEAMING_ENABLED`

---

*Note: This methodology is intended for authorized research only. Any deviation from ethical guidelines is strictly prohibited.*