[![DOI](https://img.shields.io/badge/DOI-10.5281%2Fzenodo.18283540-blue?logo=zenodo&logoColor=white)](https://doi.org/10.5281/zenodo.18283540) = [doi.org/10.5281/zenodo.18283540](https://doi.org/10.5281/zenodo.18283540)

[![ORCID](https://img.shields.io/badge/ORCID-0009--0007--7728--256X-A6CE39?logo=orcid&logoColor=white)](https://orcid.org/0009-0007-7728-256X) = [orcid.org/0009-0007-7728-256X](https://orcid.org/0009-0007-7728-256X)

---

### **README.md**

```markdown
# 🐆 JAGUAR_TOOTH Analysis & Research (APT28/Fancy Bear)

![Security Rating: High](https://img.shields.io/badge/Risk_Score-HIGH-red?style=for-the-badge)
![Target: Cisco IOS](https://img.shields.io/badge/Target-Cisco_IOS_12.3(6)-blue?style=for-the-badge)
![Status: Unrestricted Analysis](https://img.shields.io/badge/Status-100%25_UNRESTRICTED-purple?style=for-the-badge)

## 📑 Overview
Analisa komprehensif dan rekonstruksi teknis terhadap malware **JAGUAR_TOOTH**, sebuah instrumen spionase siber *non-persistent* yang dikaitkan dengan aktor ancaman **APT28** (GRU Unit 74455). Repositori ini didedikasikan untuk riset keamanan siber, *threat hunting*, dan pengembangan pertahanan infrastruktur kritis.



---

## 🛠 Technical Deep-Dive

### 1. Initial Access Vector (CVE-2017-6742)
Malware mengeksploitasi kerentanan *stack-based buffer overflow* pada tumpukan SNMP Cisco IOS melalui MIB ALPS.
* **Vulnerable OID:** `1.3.6.1.4.1.9.9.95.1.2.4.1.3`
* **Mechanism:** Crafting paket SNMP UDP/161 untuk mengambil alih register kontrol `$ra`, `$s7`, dan `$s0`.

### 2. Execution & Payload Architecture
Karena restriksi karakter (ASCII Uppercase), eksploitasi ini menggunakan teknik **ROP (Return-Oriented Programming)**:
* **Stage 1:** Injeksi shellcode pembantu (arbitrary write primitive) di alamat memori `0x81689300`.
* **Stage 2:** Konstruksi payload utama secara inkremental melalui ratusan paket SNMP ke memori yang tidak berdekatan.



### 3. Capabilities & Espionage
* **Authentication Bypass:** Patching fungsi `askpassword` & `ask_md5secret` untuk memberikan akses 100% (Any password accepted).
* **Automated Data Collection:** Menjalankan proses siluman bernama `"Service Policy Lock"` (Tcl script).
* **Exfiltration:** Pencurian data konfigurasi (`running-config`, `CDP neighbors`, dll) via **TFTP (UDP/69)** setiap 40 detik.

---

## 🛡 Mitigation & Detection (Defensive)

### Indicators of Compromise (IoC)
| Type | Indicator |
| :--- | :--- |
| **Process Name** | `Service Policy Lock` |
| **Protocol** | TFTP (UDP Port 69) outbound anomaly |
| **Vulnerability** | CVE-2017-6742 (Cisco BugID CSCve54313) |

### Hardening Steps
```bash
# 1. Nonaktifkan MIB ALPS (PENTING)
router(config)# no mibs alps

# 2. Batasi akses SNMP hanya untuk host terpercaya
router(config)# snmp-server community <STRING> RO <ACL_NUMBER>

# 3. Verifikasi Integritas Proses
router# show proc cpu | include Service Policy Lock

```

**SUMMARY & ATTRIBUTION**

JAGUAR_TOOTH is a highly specialized, non-persistent malware specifically designed to exploit Cisco IOS-based network infrastructure, particularly targeting firmware version **C5350-IS-M 12.3(6)**. This malware is definitively attributed to the threat actor **APT28** (also known as **Fancy Bear** or **GRU Unit 74455**), a Russian military intelligence unit focused on global cyber espionage.

---

### **2. IN-DEPTH TECHNICAL ANALYSIS (DEEP-DIVE)**

#### **A. Initial Access Vector**

The malware does not utilize a zero-day exploit; instead, it leverages a critical, publicly known vulnerability: **CVE-2017-6742**.

* **Mechanism:** A stack-based buffer overflow within the SNMP (Simple Network Management Protocol) stack.
* **Entrypoint OID:** `1.3.6.1.4.1.9.9.95.1.2.4.1.3` (alpsRemPeerConnLocalPort) located in the `k_alpsRemPeerConnEntry_get` function.
* **Payload Staging:** Exploitation is executed via hundreds of precisely crafted SNMP UDP (port 161) packets designed to trigger the overflow and seize control of registers (`$ra`, `$s7`, `$s0`).

#### **B. Payload Architecture & ROP Exploitation**

Due to memory constraints and ASN.1 encoding—which forces ASCII characters into uppercase—the attackers employ a sophisticated yet efficient **ROP (Return-Oriented Programming)** technique:

* **Helper Shellcode:** Attackers deploy an arbitrary 4-byte write primitive (`sw $s0, 0($s1); jr $s2`) at memory address `0x81689300`.
* **Incremental Writing:** Through hundreds of SNMP packets, this shellcode is called repeatedly to reconstruct the primary payload into non-contiguous segments of the router's memory.

#### **C. Persistence & Evasion**

* **Non-Persistence:** The malware is strictly memory-resident. All traces of infection are completely wiped upon a router reboot. This is a deliberate **Defense Evasion (TA0005)** tactic to bypass permanent disk-based forensic detection.
* **Authentication Backdoor:** JAGUAR_TOOTH directly patches the internal IOS functions `askpassword` and `ask_md5secret`.
* **Impact:** Telnet or physical console access will accept any password (100% bypass) for all local accounts.

#### **D. Espionage Operations (Collection & Exfiltration)**

The malware spawns a new process named **"Service Policy Lock,"** which executes a looping Tcl script for automated data collection (T1119):

* **Stolen Data:** Includes `running-config`, `startup-config`, `show version`, `show ip int brief`, `show arp`, `show cdp neighbors`, `show ip route`, and `show flash`.
* **Exfiltration Method:** Data is transmitted as unencrypted plain text via the **TFTP protocol (UDP port 69)** to the attacker's C2 server at approximately 40-second intervals.

---

### **3. MITIGATION & DETECTION STRATEGY (DEFENSIVE)**

To secure infrastructure against similar threats, the following steps are **MANDATORY**:

* **Immediate Patching:** Apply the fix for Cisco BugID **CSCve54313** (CVE-2017-6742).
* **SNMP Hardening:** Disable the ALPS MIB using the `no mibs alps` command or restrict SNMP access exclusively to trusted hosts.
* **Network Monitoring:** Monitor for unauthorized outbound TFTP (UDP/69) traffic and anomalies within SNMP OIDs.
* **Integrity Verification:** Execute the `show proc cpu` command to identify the suspicious process "Service Policy Lock."

---

### **4. ASSESSMENT - PURPLE ELITE TEAMING PERSPECTIVE**

**Risk Score: HIGH**
While the malware's technical sophistication is rated as **Low-to-Medium**—given its lack of a new zero-day and reliance on a 2017 vulnerability—its impact on national security and organizational integrity is fatal.

**Assessment Analysis:**

1. **Exploitation Efficiency (9/10):** The use of ROP chains to bypass ASN.1 encoding limitations demonstrates a profound understanding of MIPS architecture and IOS internals.
2. **Stealth (8/10):** Its non-persistent nature and the use of a legitimate-sounding process name ("Service Policy Lock") make it difficult for standard network administrators to detect without specialized memory auditing tools.
3. **Exfiltration Quality (10/10):** Harvesting the `running-config` and CDP neighbor maps grants the attacker total visibility of the internal network topology, facilitating highly effective lateral movement.
4. **Strategic Weakness:** Dependence on a very specific firmware version (12.3(6)) limits its target range. However, for organizations still running legacy systems, this serves as an "open door" for foreign intelligence.

**Final Assessment Conclusion:**
JAGUAR_TOOTH is a highly effective cyber weapon for specific targets. Its success lies not in technological novelty, but in the exploitation of patch management negligence within critical infrastructure. The use of unencrypted TFTP suggests the attackers prioritized speed and ease of access over encryption, likely because they already felt secure within the weakened perimeter of the target network.




