package org.xfei.server;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

import org.xfei.pojo.Message;
import org.xfei.services.Services;

public class RMIServer 
implements Services {
public RMIServer() throws RemoteException {
}

public static void main(String args[]) throws Exception {
    System.out.println("RMI server started");
    RMIServer obj = new RMIServer();
     try { 
    	Services stub = (Services) UnicastRemoteObject.exportObject(obj,0);
        Registry reg;
        try {
            reg = LocateRegistry.createRegistry(1099);
            System.out.println("java RMI registry created.");
        } catch(Exception e) {
        	System.out.println("Using existing registry");
        	reg = LocateRegistry.getRegistry();
        }
    	reg.rebind("RMIServer", stub);
    } catch (RemoteException e) {
    	e.printStackTrace();
    }
}


	public String sendMessage(Message msg) throws RemoteException {
		System.out.println("Server side msg....");
		return msg.getMessage();
	}
}

