
# Linux Kernel Version 4.14 - 4.4 (Ubuntu && Debian)

## 描述

该漏洞存在于Linux内核带有的eBPF bpf(2)系统调用中，当用户提供恶意BPF程序使eBPF验证器模块产生计算错误，导致任意内存读写问题。 非特权用户可以使用此漏洞获得权限提升。漏洞由Google project zero发现。

## 漏洞编号
CVE-2017-16995

## 威胁等级
高危

## 演示

```
bearcat@ubuntu:/opt$ lsb_release -a
No LSB modules are available.
Distributor ID: Ubuntu
Description:    Ubuntu 16.04.4 LTS
Release:        16.04
Codename:       xenial
bearcat@ubuntu:/opt$ uname -a
Linux ubuntu 4.4.0-116-generic #140-Ubuntu SMP Mon Feb 12 21:23:04 UTC 2018 x86_64 x86_64 x86_64 GNU/Linux
bearcat@ubuntu:/opt$ id
uid=1000(bearcat) gid=1000(bearcat) groups=1000(bearcat),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd),115(lpadmin),116(sambashare)
bearcat@ubuntu:/opt$ ls
exploit.c
bearcat@ubuntu:/opt$ gcc exploit.c -o exploit
bearcat@ubuntu:/opt$ ./exploit
task_struct = ffff88003a0db800
uidptr = ffff8800374b76c4
spawning root shell
root@ubuntu:/opt# id
uid=0(root) gid=0(root) groups=0(root),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd),115(lpadmin),116(sambashare),1000(bearcat)
root@ubuntu:/opt#
```

## 修复建议

1.目前暂未有明确的补丁升级方案。 建议用户在评估风险后，通过修改内核参数限制普通用户使用bpf(2)系统调用：
  
  设置参数“kernel.unprivileged_bpf_disabled = 1”通过限制对bpf（2）调用的访问来防止这种特权升级
  
  `root@Ubuntu# echo 1 > /proc/sys/kernel/unprivileged_bpf_disabled`

2.相关代码补丁
  https://github.com/torvalds/linux/commit/95a762e2c8c942780948091f8f2a4f32fce1ac6f

## 相关链接

http://cyseclabs.com/exploits/upstream44.c

https://security-tracker.debian.org/tracker/CVE-2017-16995

https://www.securityfocus.com/bid/102288

https://blog.aquasec.com/ebpf-vulnerability-cve-2017-16995-when-the-doorman-becomes-the-backdoor?utmcampaign=General%20website&utmcontent=67375488&utmmedium=social&utmsource=twitter

https://bugs.chromium.org/p/project-zero/issues/detail?id=1454&desc=

https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=95a762e2c8c942780948091f8f2a4f32fce1ac6f

https://cert.360.cn/warning/detail?id=119f849891f2a1b5deef65f99923ab5a

https://github.com/torvalds/linux/commit/95a762e2c8c942780948091f8f2a4f32fce1ac6f
  
https://github.com/jas502n/Ubuntu-0day
