#define _GNU_SOURCE
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>

// armv7l-linux-musleabihf-cross/bin/armv7l-linux-musleabihf-gcc -fPIC -shared -static shell.c -o shell.so

int install() {
    if(mkdir("/data2/busybox_bin", 0777) != 0) {
        if(errno != EEXIST) {
            fprintf(stderr, "Error: mkdir() failed at install()\n");
        }
    }

    char *argv[] = {"/usb/busybox-armv7l", "--install", "-s", "/data2/busybox_bin", NULL};
    char **env;
    fprintf(stdout, "Installing busybox symlinks in /data2/busybox_bin.\n");
    if(execve("/usb/busybox-armv7l", argv, env) == -1) {
        fprintf(stderr, "Error: execve() failed at install()\n");
        return -1;
    }
    return 0;
}

int shell() {
    char *argv[] = {"/usb/busybox-armv7l", "sh", NULL};
    char *env[] = {"PATH=/data2/busybox_bin:/usb/bin", "HOME=/usb/home", "MAGIC=/usb/bin/magic.mgc", NULL};
    if(execve("/usb/busybox-armv7l", argv, env) == -1) {
        fprintf(stderr, "Error: execve() failed at shell()\n");
        return -1;
    }
    return 0;
}

int bash_shell() {
    char *argv[] = {"/usb/bash", "--norc", NULL};
    char *env[] = {"PATH=/data2/busybox_bin:/usb/bin", "HOME=/usb/home", "MAGIC=/usb/bin/magic.mgc", NULL};
    if(execve("/usb/bin/bash", argv, env) == -1) {
        fprintf(stderr, "Error: execve() failed at bash_shell()\n");
        return -1;
    }
    return 0;
}

__attribute__((constructor))
static void init(void) {
    if(access("/data2/busybox_bin", F_OK) != 0) {
        if(install() != 0) {
            return;
        }
    } else {
        fprintf(stdout, "Select the shell.\n1. ash(busybox built-in) 2. bash\nshell:");
        fflush(stdout);
        int s = fgetc(stdin);
        switch(s) {
            case 49:
                shell();
                break;
            case 50:
                bash_shell();
                break;
        }
    }
}

int main() {
    if(access("/data2/busybox_bin", F_OK) != 0) {
        if(install() != 0) {
            return -1;
        }
    } else {
        fprintf(stdout, "Select the shell.\n1. ash (busybox built-in) 2. bash\nshell:");
        fflush(stdout);
        int s = fgetc(stdin);
        switch(s) {
            case 49:
                shell();
                break;
            case 50:
                bash_shell();
                break;
        }
    }

    return 0;
}