# CVE-2017-12945
## Exploit for CVE-2017-12945
A (remote) (authenticated) (blind) OS command injection vulnerability exists in Mersive Solstice Pods - a wireless collaboration and presentation platform designed by Mersive Technologies Inc. - running versions of the firmware prior to `2.8.4`, as acknowledged/reported on the vendor website, see the screenshot below. As a result, an authenticated adversary can run arbitrary commands (with root privileges) on vulnerable Mersive Solstice Pods by sending them crafted HTTP requests.

![changelog](images/changelog.png)

This vulnerability exists due to the lack of server-side inputs/parameters validation. Some user-controlled inputs/parameters are directly passed as arguments to a `public static String runShellCommand(String command)` method designed to execute OS commands under the context of the root user. This insecure configuration would allow an adversary to fully compromise vulnerable devices.

## References
Mitre CVE Reference: 
* https://cve.mitre.org/cgi-bin/cvename.cgi?name=2017-12945

Vendor Change Log:
* https://documentation.mersive.com/content/pages/release-notes.htm

## Affected versions
Mersive Solstice Pods running versions of the firmware prior to `2.8.4`.

## Affected components
* `com/mersive/solstice/server/EthernetInterface.java`:
```java
static void SetPrefixLength(int prefixLength) {
    int value = -1 << (32 - prefixLength);
    try {
        Log.d("Ethernet", "complete: " + ServerDisplay.runShellCommand("ifconfig eth0 netmask " + InetAddress.getByAddress(new byte[]{(byte) (value >>> 24), (byte) ((value >> 16) & 255), (byte) ((value >> 8) & 255), (byte) (value & 255)}).getHostAddress()));
    } catch (Exception e) {
        e.printStackTrace();
    }
}

static void SetGateway(String gateway) {
    if (!gateway.equals(GetGateway())) {
        Log.d("Ethernet", "complete: " + ServerDisplay.runShellCommand("ip route del default"));
        Log.d("Ethernet", "complete: " + ServerDisplay.runShellCommand("ip route add default via " + gateway + " dev " + ETH0));
    }
}

static void SetStaticIP(String ipAddr) {
    Log.d("Ethernet", "complete: " + ServerDisplay.runShellCommand("ifconfig eth0 " + ipAddr));
}
```
* `com/mersive/solstice/server/ServerDisplay.java`:
 ```java
public static String runShellCommand(String command) {
    return runShellCommand(command, true);
}

public static String runShellCommand(String command, boolean wait) {
    Log.d("Shell Command", command);
    try {
        Process process = Runtime.getRuntime().exec("shell-tunnel --client");
        DataOutputStream stdin = new DataOutputStream(process.getOutputStream());
        InputStream is = process.getInputStream();
        stdin.writeBytes(command + "\n");
        stdin.flush();
        stdin.writeBytes("exit\n");
        stdin.flush();
        if (wait) {
            process.waitFor();
        }
        byte[] buffer = new byte[1024];
        Arrays.fill(buffer, 0);
        return new String(buffer, 0, is.read(buffer));
    } catch (Exception e) {
        e.printStackTrace();
        return "";
    }
}
```

## Attack vectors
To exploit this vulnerability, an authenticated adversary would need to send a specifically crafted request to devices running vulnerable version of the firmware (prior to `2.8.4`). This request could either be sent directly from the device web interface (from the `set static IP address` form) itself, or alternatively, it could be sent using a command line utility such as `cURL`.

In either case, the payload would need to be preceded by a special character instructing `/bin/sh` to run consecutive commands, e.g. the `;` or `&` character, for the payload to get executed after completion of the original/legitimate command.

The `staticIP` parameter which is one of the multiple vulnerable parameters along with the `gateway` parameter is not validated server-side and is instead directly passed as an argument to the `static void SetStaticIP(String ipAddr)` method which in turn passes it as an argument to the `public static String runShellCommand(String command)` method.

This configuration would allows an authenticated adversary to run arbitrary commands on vulnerable devices under the context of the root user.

## License
   Copyright (C) 2019 Alexandre Teyar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

<http://www.apache.org/licenses/LICENSE-2.0>

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
   limitations under the License.
