**CVE-2017-0037 (Microsoft Browser Memory Corruption Vulnerability)**

This document is about **CVE-2017-0037- Microsoft Browser Memory
Corruption Vulnerability**. It will first introduce what a **Remote Code
Execution (RCE)** is and then go over through some technical specifics.

**What is Remote Code Execution?**

A cyber-attack in which an attacker may remotely execute commands on
another computer is known as remote code execution. Remote code
executions (RCEs) are most commonly caused by harmful software
downloaded by the host and can occur independent of the system\'s
location.

To achieve RCE, the following ways can be used-

1)  **Injection Attacks**: Here, the attacker supplies erroneous input
    with the intent of having a portion of it processed as part of the
    command.

2)  **Deserialization Attacks**: The deserialization program may read
    carefully formulated user input within the serialized data as
    executable code.

3)  **Out-of-Bounds Write**: An attacker may be able to construct an
    input that goes beyond the allotted buffer if memory allocation is
    done poorly. Because executable code is also kept in memory, the
    program may be able to run user-provided data if it is written in
    the correct location.

4)  **Type Confusion Attack**: There is a threat of type confusion when
    a source code doesn\'t really take any action to verify the
    authenticity of an entity that is supplied to it. Because type
    confusion permits a hacker to smuggle in code that can run random
    instructions merely by causing a discrepancy in object types, it is
    risky.

**Execution of RCE Attack**

An RCE assault sequence is simple to carry out. First, the threat actor
searches the internet for common vulnerabilities that may be exploited
in an effective assault. After identifying a particular vulnerability,
the hacker uses the exploit to obtain access. Now that they\'ve gained
access, they may use the malicious script to accomplish their
objectives, which include data exfiltration, money laundering,
comprehensive surveillance, and service disruption.

The language of the intended application is frequently used to inject
code. The language is then executed by the server-side processor.
Python, Java, Perl, Ruby, and PHP are common programming languages. Code
injection is common in platforms that immediately analyze unverified
input. Public online apps are, indeed, a big focus for hackers.

Malicious script is typically executed by bash scripts. A bash script is
a text document that includes commands that would normally be typed into
the command prompt. Bash scripts enable the included commands to
function correctly. It is customary to attach a \".sh\" to them,
although it is not needed. After packaging, the hacker puts the code
into a susceptible app, which then runs it. The application might also
give a decision to the kernel to have it run.

**Attack Metrics**

The following image focuses on the base score metrics of CVE-2017-0037 .

![Alt text](https://github.com/chattopadhyaykittu/CVE-2017-0037/blob/main/Screenshot%202022-03-27%20at%209.26.13%20PM.png?raw=true "Title")

[Source](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2017-0037)

The **CVSS rating score** here is **8.1(high)**.

**Attack Vector**- The vulnerable component here is tied to the network
stack, and the range of potential hackers includes anything from the
other alternatives stated to the entire Internet.

The **Attack Complexity** of this vulnerability is high, that is, the
success of an assault is contingent on circumstances outside the
attacker\'s authority. So, an attack cannot be completed at will, but
rather needs the attacker to expend a meaningful level of work in
planning or implementation against the susceptible element before it can
be anticipated to be effective.

**Confidentiality** value here is high which means there is a complete
loss of confidentiality, resulting in the attacker having access to all
resources inside the damaged component.

**Integrity** is high which means there is a severe loss of integrity
and protection.

**Availability** is high which means there is a complete loss of
availability, allowing the attacker to completely prohibit access to the
afflicted component\'s resources.

**Attack Details**

The CVE-2017-0037 vulnerability was a type-confusion flaw which resided
in Microsoft Edge and Internet Explorer 10 and 11. It let attackers
execute code remotely on the target machine when the user visited a
malicious website.

The flaw was pointed out by **Google researcher Ivan Frantic** and the
details of the vulnerability were released by Google since Microsoft was
unable to fix it within its 90-day disclosure period.

![Alt text](https://github.com/chattopadhyaykittu/CVE-2017-0037/blob/main/Screenshot%202022-03-27%20at%209.27.04%20PM.png?raw=true "Title")

[Source](https://www.onmsft.com/news/google-outs-microsoft-security-flaw-once-again-this-time-an-ieedge-browser-vulnerability)

The **proof-of-concept (PoC)** exploit published by the researcher
reveals that it can crash Edge and IE, allowing an attacker to execute
code remotely and gain administrator privileges of the compromised
system. He also confirmed that the attack worked on the 64-bit version
of Internet Explorer on Windows Server 2012 R2 and it affected 32-bit IE
11 as well as Microsoft Edge.

The **type confusion** is in the

**Layout::MultiColumnBoxBuilder::HandleColumnBreakOnColumnSpanningElemnt**
function in **mshtml.dll**. By executing arbitrary code remotely, via
vectors which involve **Cascading Style Sheets (CSS)** token sequence
and crafted **JavaScript** code which operate on a **TH** element the
attack can occur.

**The PoC by Ivan Fratric of Google Project Zero**

![Alt text](https://github.com/chattopadhyaykittu/CVE-2017-0037/blob/main/Screenshot%202022-03-27%20at%206.09.35%20PM.png?raw=true "Title")

[Source](https://bugs.chromium.org/p/project-zero/issues/detail?id=1011)

As stated by researcher Ivan Frantic, the PoC crashes in

**MSHTML!Layout::MultiColumnBoxBuilder::HandleColumnBreakOnColumnSpanningElement**
when reading from address **0000007800000070**.

![Alt text](https://github.com/chattopadhyaykittu/CVE-2017-0037/blob/main/Screenshot%202022-03-27%20at%206.11.13%20PM.png?raw=true "Title")

[Source](https://bugs.chromium.org/p/project-zero/issues/detail?id=1011)

![Alt text](https://github.com/chattopadhyaykittu/CVE-2017-0037/blob/main/Screenshot%202022-03-27%20at%206.12.12%20PM.png?raw=true "Title")

[Source](https://bugs.chromium.org/p/project-zero/issues/detail?id=1011)

By analyzing the code around the point of the crash, it can be observed
that at memory address 00007ffe\`8f330a51, the contents from the
register **rbp** is read into the register **rcx**. Then the call to

**MSHTML!Layout::Patchable\<Layout::PatchableArrayData\<Layout::MultiColumnBox::SMultiColumnBoxItem\>
\>::Readable** assigns value to rax (it is a designated register to
store return values from functions).

Though **rcx** is supposed to point to another object type, but in the
PoC as shown above, it points to an array of 32-bit integers allocated
in **Array\<Math::SLayoutMeasure\>::Create**. The offsets of the table
columns are stored in that array and an attacker can take control over
it. The crash occurs at **00007ffe\`8f330a59** since **rax points to
uninitialized memory**. rax stores the return value of the function

**MSHTML!Layout::Patchable\<Layout::PatchableArrayData\<Layout::MultiColumnBox::SMultiColumnBoxItem\>
\>::Readable** which is not an initialized memory address. The attacker
can point rax to some memory location which they can control. The
attacker can modify table properties such as border-spacing and the
width of the first TH element to gain control over rax.

![Alt text](https://github.com/chattopadhyaykittu/CVE-2017-0037/blob/main/Screenshot%202022-03-27%20at%206.12.51%20PM.png?raw=true "Title")

[Source](https://bugs.chromium.org/p/project-zero/issues/detail?id=1011)

If the attacker is able to gain control over **rax on line
00007ffe\`8f330a59**, the function

**MSHTML!Layout::Patchable\<Layout::PatchableArrayData\<Layout::MultiColumnBox::SMultiColumnBoxItem\>
\>::Readable** is called again on line **00007ffe\`8f330a5d 743d** with
the same arguments and a jump to a higher address. After that, through a
series of differences which start from **rax**, a function pointer could
be obtained and stored in **rdi**. If the attacker could pass a **CFG
check** on that function pointer, the attacker-controlled function
pointer would be called on line **00007ffe\`8f330a80**.

**Probable Patch of the Bug**

As suggested by Ivan Fratric, firstly the reason behind the occurrence
of the type confusion must be detected. According to his hypothesis, two
types of columns exist in DOM: HTML table columns and CSS columns,
IE/Edge was getting confused between the two. So, if a type check
somewhere was added in the vulnerable function, it could have solved it.

**Useful Links**

-   [Bug Reported by Ivan
    Fratric](https://bugs.chromium.org/p/project-zero/issues/detail?id=1011)

-   [Microsoft Browser Memory Corruption
    Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2017-0037)

**Impacts of RCE Attack**

1)  **Initial Access**: Attackers can utilize this to get a grip on a
    device and install malware or accomplish other objectives.

2)  **Information disclosure**: RCE attacks help to install
    information-stealing malware or to run commands that collect and
    steal data from the affected device.

3)  **Denial of Service**: An RCE flaw allows hackers to execute code on
    the machine that hosts the affected app and hence, disrupt its
    operation and other programs\' on the system.

4)  **Cryptomining**: Cryptomining malware is frequently deployed and
    executed on susceptible devices.

5)  **Ransomware**: Ransomware is a type of software that prevents a
    user from accessing their files unless they pay money.

**Ways to Mitigate RCE Attacks**

1)  Buffer overflow control can be used to mitigate RCE attacks.

2)  Access control lists are useful for limiting user privileges and,
    hence limiting an attacker\'s abilities if they get control of a
    user\'s account.

3)  Network traffic should be monitored for potentially malicious
    content in addition to monitoring endpoints.

4)  Using Input sanitization which is the process of cleaning and
    scrubbing input from the user to protect it from being used to
    exploit security flaws.

**References**

- https://msrc.microsoft.com/update-guide/vulnerability/CVE-2017-0037

- https://www.checkpoint.com/cyber-hub/cyber-security/what-is-remote-code-execution-rce/#:~:text=In%20an%20injection%20attack%2C%20the%20attacker%20deliberately%20provides%20malformed%20input%20that%20causes%20part%20of%20their%20input%20to%20be%20interpreted%20as%20part%20of%20the%20command

- https://www.bugcrowd.com/glossary/remote-code-execution-rce/

-  https://nvd.nist.gov/vuln/detail/CVE-2017-0037

- https://bugs.chromium.org/p/project-zero/issues/detail?id=1011

- https://blog.0patch.com/2017/03/0patching-another-0-day-internet.html

- https://www.cs.uaf.edu/2017/fall/cs301/lecture/09_11_registers.html

- https://reverseengineering.stackexchange.com/questions/10746/what-does-mov-qword-ptr-dsrax18-r8-mean
