# CVE-2016-6415-BenignCertain-Monitor
Re-implementation of VirtueSecurity's benigncertain-monitor. Doesn't have all the same payload options as the original, but replaces the `bc-id` binary with a better proof of concept by Ross Bradley that can be expanded on if necessary.

## Credits:
- Original monitor written and maintained by VirtueSecurity at https://github.com/VirtueSecurity/benigncertain-monitor
- Proof of concept script used to replace the buggy "bc-id" binary is from Ross Bradley at https://github.com/ross-bradley/benign-certain

```
$ git clone https://github.com/3ndG4me/CVE-2016-6415-BenignCertain-Monitor.git
$ cd CVE-2016-6415-BenignCertain-Monitor
$ sudo docker build . -t benign-monitor
$ sudo docker run -it benign-monitor <host>
```
The service will continuously poll the vulnerable service, extract ascii strings from memory, store the strings in a local sqlite database, and show the most frequently observed strings:

```
Starting monitor against 10.0.6.1
        string  count
0         5$dx      3
1          0(0      3
2         $c{l      3
3       (0"t&j      3
4   R$dkd$hf7!      2
5    %d1N=8$i-      2
6        $c)P0      1
7         1NlD      1
8        1NlD'      1
9       $c)P(0      1
10     $c)P1@_      1
```

## Overview
This is a dockerized python script that continuously leaks memory of a target vulnerable to the NSA BENIGNCERTAIN Cisco exploit CVE-2016-6415. 

The script polls the vulnerable service over time to identify probable passwords and other potentially sensitive information. This can be used to harvest actionable data over a period of time rather than just a proof of concept exploit.

## TODO:
- [ ] Port exploit code to python3
- [ ] Expand arguments to passthru from the container to the exploit script for better option tweaking
- [ ] Optional: Expand payload options
