Sweet32
=======

This is a demonstration of the Sweet32 attack (CVE-2016-2183): https://sweet32.info/

The attack is an example of a birthday attack which exploits crypto algorithms
with small block sizes (64-bit) in CBC mode, such as 3DES and Blowfish.
The attack requires generation of a lot of encrypted blocks with known plaintext.
After the generation, identical encrypted blocks can be identified and used to
identify the plaintext value of the blocks with unknown plaintext.

This implementation uses **3DES (Triple DES)** as its encryption algorithm,
which has a 64-bit (8 byte) block size - the same block size that makes
real-world 3DES vulnerable to the Sweet32 attack.

## The Attack Formula (Beastly Attack)

When two ciphertext blocks collide (`c_i = c_j`), we can recover unknown plaintext using:

```
p_i = p_j ⊕ c_{i-1} ⊕ c_{j-1}
```

Where:
- `p_i` is the unknown plaintext (e.g., secret cookie)
- `p_j` is known plaintext (e.g., HTTP headers)
- `c_{i-1}` and `c_{j-1}` are the previous ciphertext blocks

This works because in CBC mode, a collision means the *inputs* to the block cipher
were equal, allowing XOR recovery without knowing the encryption key.

## Quick Demo

Run the demo with a guaranteed collision:

```sh
# Step 1: Generate encrypted packet with secret cookie
python generate_rigged_packets.py rigged_demo.bin

# Step 2: Execute the attack to recover the cookie
python sweet32.py --block-size 8 rigged_demo.bin
```

The attack will show the SECRET COOKIE value, then recover it using only the ciphertext!

## Scripts

### `generate_rigged_packets.py`

Creates a packet with a **guaranteed collision** for demonstration purposes.
The cookie value is crafted so that it collides with a known-plaintext block.

### `sweet32.py`

Execute the Sweet32 birthday attack to recover the cookie.

## About Sweet32

The Sweet32 attack exploits the birthday paradox. For a 64-bit block cipher:
- After ~2^32 blocks (~32GB of data), collisions become likely
- When two ciphertext blocks collide, XORing them reveals XOR of plaintexts
- If one plaintext is known, the other can be recovered

This makes 3DES (and other 64-bit block ciphers) vulnerable in long-lived
HTTPS sessions.

## Stats

For the actual Sweet32 attack on 3DES (64-bit blocks):

|Block size| Block size| Num Packets| Data needed| Block count|
|---|---|---|---|---|
|8 byte| 64 bits| ~785GB| ~785GB| ~2^32 blocks|

The real attack requires ~785GB of data to be encrypted under the same key,
which is why it primarily affects long-lived HTTPS connections.
