# CVE-2016-15041 Lab - MainWP Dashboard Stored XSS

Vulnerable lab for CVE-2016-15041: Unauthenticated stored XSS in MainWP Dashboard WordPress plugin <= 3.1.2.

## Quickstart

```bash
docker compose up -d --build
```

Wait ~30 seconds for auto-setup. The lab prints a banner when ready:

```bash
docker compose logs -f wordpress
```

## Access

| Resource | URL / Credentials |
|----------|-------------------|
| WordPress | http://localhost:8088 |
| Admin Login | `admin` / `admin123` |
| Vulnerable Endpoint | http://localhost:8088/wp-admin/admin-post.php?page=mainwp-setup&step=purchase_extension |

## Validate

**Nuclei:**
```bash
nuclei -t https://raw.githubusercontent.com/projectdiscovery/nuclei-templates/main/http/cves/2016/CVE-2016-15041.yaml -u http://localhost:8088
```

**Manual PoC:**
```bash
./scripts/poc.sh http://localhost:8088
```

## Cleanup

```bash
docker compose down -v
```

---

## Vulnerability Details

| Field | Value |
|-------|-------|
| CVE | CVE-2016-15041 |
| Severity | High |
| Type | Stored XSS (Unauthenticated) |
| Affected | MainWP Dashboard <= 3.1.2 |
| Fixed | 3.1.3 |

### Description

The MainWP Dashboard Quick Setup Wizard is accessible without authentication. An attacker can inject JavaScript via the `mwp_setup_purchase_username` parameter. The payload is stored in WordPress options and rendered without escaping when an admin views the Extensions page.

### Attack Flow

1. `GET /wp-admin/admin-post.php?page=mainwp-setup&step=purchase_extension` → get CSRF nonce (no auth required)
2. `POST` XSS payload with the nonce (no auth required)
3. Admin visits Extensions page → JavaScript executes in admin context

### Impact

- Session hijacking / cookie theft
- WordPress admin account takeover
- Remote code execution via theme/plugin editor

## References

- [Klikki Advisory](https://klikki.fi/mainwp-admin-panel-unauthenticated-stored-xss/)
- [NVD](https://nvd.nist.gov/vuln/detail/CVE-2016-15041)

## Technical Notes

The vulnerable plugin (v3.1.2) was obtained from WordPress SVN revision r1394563 (April 14, 2016). Minor PHP 8 compatibility patches were applied that do not affect the vulnerability:
- Replaced deprecated `__autoload()` with `spl_autoload_register()`
- Fixed curly brace array access syntax

The XSS vulnerability exists in `view/view-mainwp-extensions-view.php` line 74 where `$username` is echoed without `esc_attr()`.

