# SSH NEWKEYS Flood PoC (CVE-2016-10708)

---

## Description

This proof-of-concept script exploits a vulnerability in OpenSSH versions prior to 7.4 (CVE-2016-10708) by sending unexpected `SSH_MSG_NEWKEYS` packets which can result in DoS. It can operate in two modes:

- **scan**: Connects to one or more SSH servers, retrieves their banner, parses the OpenSSH version, and reports whether the target is vulnerable.
- **attack**: Opens multiple simultaneous connections and floods the server with crafted `NEWKEYS` messages to trigger a denial-of-service condition.

---

## Warning & Legal Notice

This tool is provided for research and educational purposes only. Unauthorized scanning or attacking of systems that you do not own or have explicit permission to test may violate applicable laws and regulations.

Use this script responsibly:

- Only run against systems you own or have been granted written permission to test.
- Review all relevant laws, regulations, and organizational policies before any testing.
- The author assumes no liability for misuse or damage resulting from this tool.

---

## Requirements

- Python 3.6 or later
- No third-party dependencies

## Command Options

- `-t, --targets`
  Comma-separated list of target IPs or hostnames (required)

- `-p, --port`
  SSH port to connect to (default: 22)

- `-m, --mode`
  Operation mode: `scan` or `attack` (required)

- `--sockets`
  Number of TCP connections to open per target (default: 5)

- `--threads`
  Maximum number of concurrent worker threads (default: 10)

- `-v, --verbose`
  Enable debug-level logging output

---

## How It Works

1. **Banner Exchange**
   In scan mode the script connects to each target and reads the SSH banner to extract the OpenSSH version.

2. **Connection Setup**
   In attack mode it opens the specified number of TCP sockets per target and immediately sends a fake client banner (`SSH-2.0-OpenSSH_8.9`), then holds the connections open.

3. **Packet Crafting**
   It builds raw SSH transport packets containing only the `SSH_MSG_NEWKEYS` payload. Packet length, padding length, and random padding are calculated to conform to the SSH binary packet protocol.

4. **Flood Loop**
   The script enters an infinite loop, sending the crafted `NEWKEYS` packet on every socket with randomized sub-millisecond delays. Unpatched sshd instances will mishandle the out-of-order `NEWKEYS` messages and eventually crash or become unstable.
