# PoC for CVE-2016-1000027

This is a demo Spring Boolt application that is affected by [CVE-2016-1000027](https://nvd.nist.gov/vuln/detail/CVE-2016-1000027).

# Steps to reproduce the vulnerability

1. Start a vulnerable server `com.gypsyengineer.server.Server`.
2. Run `com.gypsyengineer.client.Exploit`.

The [`Exploit`](client/src/main/java/com/gypsyengineer/client/Exploit.java) class reads `payload.bin` and sends it to the vulnerable server.
`payload.bin` contains a payload generated by [ysoserial](https://github.com/frohoff/ysoserial).
The current `payload.bin` is `CommonsCollections5` that runs `gedit`:

```
java -jar target/ysoserial-0.0.6-SNAPSHOT-all.jar CommonsCollections5 gedit > payload.bin
```

# How to fix an application that is affected by CVE-2016-1000027

The issue has not been fixed in Spring Framework. See https://github.com/spring-projects/spring-framework/issues/24434

Here is what can be done on application side.

1. The best way is to stop using `HttpInvokerServiceExporter` and `RemoteInvocationSerializingExporter` classes.
   They are already deprecated and will likely be remove in next versions of Spring Framework.
2. Do not accept untrusted data in the endpoints that are based on these vulnerable classes.
3. Use serialization filters that were introduced by JEP 290.

# Links

1.  [[R2] Pivotal Spring Framework HttpInvokerServiceExporter readRemoteInvocation Method Untrusted Java Deserialization](https://www.tenable.com/security/research/tra-2016-20)
1.  [OWASP: Deserialization of untrusted data](https://owasp.org/www-community/vulnerabilities/Deserialization_of_untrusted_data)
1.  The application is based on [this](https://github.com/eugenp/tutorials/tree/master/spring-remoting/remoting-http).
