# CVE-2015-9331 POC

## 漏洞描述

CVE-2015-9331 是 WordPress 插件 WP All Import 中的一个任意文件上传漏洞。该漏洞允许未经身份验证的攻击者上传任意文件到服务器，可能导致远程代码执行。

## 影响范围

- **插件名称**: WP All Import
- **影响版本**: <= 3.2.3
- **漏洞类型**: 任意文件上传 / 远程代码执行
- **CVE编号**: CVE-2015-9331

## 文件说明

- `poc.py` - Python 漏洞利用脚本
- `shell.php` - 用于演示的 PHP Webshell

## 使用方法

### 环境要求

```bash
pip install requests
```

### 运行 POC

```bash
python poc.py
```

运行后按提示输入目标 URL（例如：`http://example.com`），脚本将自动上传 shell 并返回访问地址。

### 工作原理

1. 脚本通过 `/wp-admin/admin-ajax.php` 端点上传恶意 PHP 文件
2. 利用时间戳和 MD5 计算上传目录路径
3. 返回可访问的 Webshell 地址

## 免责声明

⚠️ **警告**: 此工具仅用于安全研究和授权的渗透测试。

- 未经授权使用此工具进行攻击是违法行为
- 使用者需对自己的行为负责
- 作者不对任何滥用行为承担责任
- 请确保在使用前获得明确的书面授权

## 修复建议

- 升级 WP All Import 插件到最新版本
- 实施严格的文件上传验证
- 限制 admin-ajax.php 的访问权限
- 使用 Web 应用防火墙 (WAF)

## 参考链接

- [CVE-2015-9331 详情](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2015-9331)
- [NVD 数据库](https://nvd.nist.gov/vuln/detail/CVE-2015-9331)

## 许可证

本项目仅供教育和研究目的使用。

---

**注意**: 请负责任地使用此工具，仅在获得授权的环境中进行测试。
