#!/bin/bash

#install gcc and clang compailers
sudo apt install gcc
sudo apt install clang

#install AFL
wget http://lcamtuf.coredump.cx/afl/releases/afl-2.52b.tgz
tar -xzvf afl-2.52b.tgz; rm afl-2.52b.tgz

#build the afl-fuzzer
cd afl-2.52b 
make; sudo make install

#enable llvm_mode for fast fuzzing
cd llvm_mode
sudo apt-get install llvm-dev llvm
make
cd ..
make; sudo make install

#cd to project root folder
cd ..

#create compile cover.c to  binary file with afl-clang-fast instrumentation for fuzzing
cd curl_path_san_cover
afl-clang-fast -g -fsanitize=address cover.c -o cover
cd ..

#create the test corpus for fuzzer
mkdir inputs
touch inputs/test_url.txt
echo "\"/xxx/\"" > inputs/test_url.txt

mkdir out

echo core >/proc/sys/kernel/core_pattern

#start fuzzer
AFL_USE_ASAN=1 afl-2.52b/afl-fuzz -m none -i inputs -o out ./curl_path_san_cover/cover @@

exit 0
