var wirelessSecurityModel =
{
	eventHandler: function(args)
	{
		switch(args.id)
		{
			case "wirelessSecurityModel.parseAirTouchQuery":
				wirelessSecurityModel.parseAirTouchQuery();
				break;
			case "wirelessSecurityModel.parseAPListQuery":
				wirelessSecurityModel.parseAPListQuery();
				break;
			case "wirelessSecurityModel.parseCapabilitiesQuery":
				wirelessSecurityModel.parseCapabilitiesQuery();
				break;
			case "wirelessSecurityModel.parseFreqQuery":
				wirelessSecurityModel.parseFreqQuery();
				break;
			case "wirelessSecurityModel.parseInstListQuery":
				wirelessSecurityModel.parseInstListQuery();
				break;
			case "wirelessSecurityModel.parseSecurityValuesQuery":
				wirelessSecurityModel.parseSecurityValuesQuery();
				break;
			case "wirelessSecurityModel.parseSSIDQuery":
				wirelessSecurityModel.parseSSIDQuery();
				break;
			case "wirelessSecurityModel.parseTxmodeQuery":
				wirelessSecurityModel.parseTxmodeQuery();
				break;
			case "wirelessSecurityModel.parseWDSListQuery":
				wirelessSecurityModel.parseWDSListQuery();
				break;
			case "wirelessSecurityModel.parseWDSPropertiesQuery":
				wirelessSecurityModel.parseWDSPropertiesQuery();
				break;
		}
	},

	instances: [],

	parseAirTouchQuery: function()
	{
		for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
		{
			wirelessSecurityModel.instances[i].parseAirTouchQuery();
		}
	},

	parseAPListQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.parseAPListQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].parseAPListQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.parseAPListQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseCapabilitiesQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.parseCapabilitiesQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].parseCapabilitiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.parseCapabilitiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseFreqQuery: function()
	{
		for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
		{
			wirelessSecurityModel.instances[i].parseFreqQuery();
		}
	},

	parseInstListQuery: function()
	{
		wirelessSecurityModel.instances = [];
		global.log({functionName: "wirelessSecurityModel.parseInstListQuery", message: "called!", level: 100});
		if(top.xmlResponseObject["devmgr-0"]["wireless_core.inst0"]) wirelessSecurityModel.instances.push(new wirelessCore("wireless_core-0"));
		var i = 0;
		while(top.xmlResponseObject["devmgr-0"]["wireless.inst" + i])
		{
			wirelessSecurityModel.instances.push(new wirelessNg(top.xmlResponseObject["devmgr-0"]["wireless.inst" + i]));
			i++;
		}
	},

	parseSecurityValuesQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.parseSecurityValuesQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].parseSecurityValuesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.parseSecurityValuesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseSSIDQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.parseSSIDQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].parseSSIDQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.parseSSIDQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseTxmodeQuery: function()
	{
		for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
		{
			wirelessSecurityModel.instances[i].parseTxmodeQuery();
		}
	},

	parseWDSListQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.parseWDSListQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].parseWDSListQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.parseWDSListQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseWDSPropertiesQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.parseWDSPropertiesQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].parseWDSPropertiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.parseWDSPropertiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	sendAirTouchQuery: function()
	{
		for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
		{
			wirelessSecurityModel.instances[i].sendAirTouchQuery();
		}
		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseAirTouchQuery"});
	},

	sendAPListQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.sendAPListQuery", message: "called!", level: 100});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless_ap"});
		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseAPListQuery"});
	},

	sendCapabilitiesQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.sendCapabilitiesQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].sendCapabilitiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.sendCapabilitiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseCapabilitiesQuery"});
	},

	sendFreqQuery: function()
	{
		for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
		{
			wirelessSecurityModel.instances[i].sendFreqQuery();
		}
		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseFreqQuery"});
	},

	sendInstListQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.sendInstListQuery", message: "called!", level: 100});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless_core"});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless"});
		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseInstListQuery"});
	},

	sendSecurityValuesQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.sendSecurityValuesQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].sendSecurityValuesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.sendSecurityValuesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseSecurityValuesQuery"});
	},

	sendSSIDQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.sendSSIDQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].sendSSIDQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.sendSSIDQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseSSIDQuery"});
	},

	sendTxmodeQuery: function()
	{
		for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
		{
			wirelessSecurityModel.instances[i].sendTxmodeQuery();
		}
		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseTxmodeQuery"});
	},

	sendWDSListQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.sendWDSListQuery", message: "called!", level: 100});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless_wds"});
		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseWDSListQuery"});
	},

	sendWDSPropertiesQuery: function()
	{
		global.log({functionName: "wirelessSecurityModel.sendWDSPropertiesQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessSecurityModel.instances.length; i++)
			{
				wirelessSecurityModel.instances[i].sendWDSPropertiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.sendWDSPropertiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessSecurityModel", id: "wirelessSecurityModel.parseWDSPropertiesQuery"});
	},

	setQuery: function(args)
	{
		global.log({functionName: "wirelessSecurityModel.setQuery", message: "called!", level: 100});
		try
		{
			wirelessSecurityModel.instances[args.instanceId].setQuery(args.newDataToSave);
		}
		catch(e)
		{
			global.log({functionName: "wirelessSecurityModel.setQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	}
};
