var wirelessMeshView =
{
		managerTab:
		{
			managerTab: "",
			managerTabId: "",
			wirelessDiv: "",
			addRow:
			{
				wpaWarning: function(index)
				{
					var instance = wirelessMeshView.instances[index];
					var mt = wirelessMeshView.managerTab;
					var wpaWarningSpanTemplate = '<span id="__ML_mesh_wpa_warning" ml="__ML_mesh_wpa_warning"></span>';

					var div = $("<div class='textCenter'></div>").appendTo(mt.wirelessDiv);
					div.append(wpaWarningSpanTemplate);
				},

				staWarning: function(index)
				{
					var instance = wirelessMeshView.instances[index];
					var mt = wirelessMeshView.managerTab;
					var wpaWarningSpanTemplate = '<span id="__ML_wireless_mesh_bridge_mode_warning" ml="__ML_wireless_mesh_bridge_mode_warning"></span>';

					var div = $("<div class='textCenter'></div>").appendTo(mt.wirelessDiv);
					div.append(wpaWarningSpanTemplate);
				},

				searchApButton: function(index)
				{
					var instance = wirelessMeshView.instances[index];
					var mt = wirelessMeshView.managerTab;

					instance.searchApButtonId = mt.getId.searchApButtonId(index);

					var searchApButtonTemplate = '<input type="button" id="<id>" ml="__ML_search_ap" class="LargeInputButton" onclick="wirelessMeshView.actions.searchApButtonClicked(<index>);" />';

					var div = $('<div class="textCenter"></div>').appendTo(mt.wirelessDiv);

					div.append(searchApButtonTemplate.replace("<id>", instance.searchApButtonId).replace("<index>", index));
				},

				addConnection: function(index)
				{
					var instance = wirelessMeshView.instances[index];
					var mt = wirelessMeshView.managerTab;

					instance.addConnectionSpanId = mt.getId.addConnectionSpanId(index);
					instance.addConnectionControlId = mt.getId.addConnectionControlId(index);
					instance.addConnectionButtonId = mt.getId.addConnectionButtonId(index);

					var addConnectionSpanTemplate = '<span id="<id>" ml="__ML_wireless_add_connection_label"></span>';
					var addConnectionControlTemplate = '<input type="text" id="<id>" size="20" maxlength="17" />';
					var addConnectionButtonTemplate = '<input type="button" id="<id>" ml="__ML_add" onclick="wirelessMeshView.actions.addMacButtonClicked(<index>)" />'; // if(PageValidate('addWds')){if(addWds($('#mac_address').val())) $('#mac_address').val('');}

					var addConnectionInfoTemplate = '<span id="__ML_write_mac_address_format" ml="__ML_write_mac_address_format"></span>';

					var div = $('<div class="textCenter"></div>').appendTo(mt.wirelessDiv);

					div.append(addConnectionSpanTemplate.replace("<id>", instance.addConnectionSpanId) + "" + addConnectionControlTemplate.replace("<id>", instance.addConnectionControlId) + "" + addConnectionButtonTemplate.replace("<id>", instance.addConnectionButtonId).replace("<index>", index) + "<br /><br />" + addConnectionInfoTemplate);
				},

				wdsTable: function(index)
				{
					var instance = wirelessMeshView.instances[index];
					var mt = wirelessMeshView.managerTab;

					instance.wdsTableTbodyId = mt.getId.wdsTableTbodyId(index);

					var wdsTableMeshListSpanTemplate = '<span id="__ML_wireless_mesh_list" ml="__ML_wireless_mesh_list"  class="large"></span>';
					var wdsTableStatusSpanTemplate = '<span id="__ML_mesh_status" ml="__ML_mesh_status"></span>';
					var wdsTableBssidSpanTemplate = '<span id="__ML_wireless_bssid_mac_address" ml="__ML_wireless_bssid_mac_address"></span>';

					var div = $('<div></div>').appendTo(mt.wirelessDiv);
					var title = $('<div class="textCenter">'+wdsTableMeshListSpanTemplate+'</div>').appendTo(div);
					var table = $('<table class="marginCenter widthAuto"></table>').appendTo(div);
					var thead = $('<thead><tr><th>'+wdsTableStatusSpanTemplate+'</th><th>'+wdsTableBssidSpanTemplate+'</th><th></th></tr></thead>').appendTo(table);
					var tbody = $('<tbody id='+instance.wdsTableTbodyId+'></tbody>').appendTo(table);

				},

				wdsTableTbody: function(index)
				{
					var instance = wirelessMeshView.instances[index];
					var mt = wirelessMeshView.managerTab;

					var wdsTableEnabledControlTemplate = '<input id="<id>" type="checkbox" <checked> onclick="wirelessMeshView.actions.wdsTableEnabledControlClicked(<index>,<wds_index>);" />';
					var wdsTableMacAddressTemplate = '<span id="<id>"><text></span>';
					var wdsTableDeleteButtonTemplate = '<input type="button" id="<id>" ml="__ML_delete" class="ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only" value="<value>" onclick="wirelessMeshView.actions.wdsTableDeleteButtonClicked(<index>,<wds_index>);" />';

					$("#" + instance.wdsTableTbodyId).html("");
					var j = 0;
					for(var i=0; i<instance.wds_list.length; i++)
					{
						instance.wdsTableEnabledControlId = mt.getId.wdsTableEnabledControlId(index, i);
						instance.wdsTableMacAddressLabelId = mt.getId.wdsTableMacAddressLabelId(index, i);
						instance.wdsTableDeleteButtonId = mt.getId.wdsTableDeleteButtonId(index, i);

						if(!instance.wds_list[i].removed && instance.wds_list[i].mac != "")
						{
							var row = $('<tr class="class'+j%2+'"></tr>');
							$('<td></td>').append(wdsTableEnabledControlTemplate.replace("<id>", instance.wdsTableEnabledControlId).replace("<checked>", instance.wds_list[i].enabled ? 'checked="checked"' : "").replace("<index>", index).replace("<wds_index>", i)).appendTo(row);
							$('<td></td>').append(wdsTableMacAddressTemplate.replace("<id>", instance.wdsTableMacAddressLabelId).replace("<text>", instance.wds_list[i].mac)).appendTo(row);
							$('<td></td>').append(wdsTableDeleteButtonTemplate.replace("<id>", instance.wdsTableDeleteButtonId).replace("<value>", globalView.getMultiLanguageText("__ML_delete")).replace("<index>", index).replace("<wds_index>", i)).appendTo(row);

							$("#" + instance.wdsTableTbodyId).append(row);
							j++;
						}

					}
				},

				apTable: function(index)
				{
					var instance = wirelessMeshView.instances[index];
					var mt = wirelessMeshView.managerTab;

					instance.wirelessMeshApTableId = mt.getId.wirelessMeshApTableId(index);
					instance.wirelessMeshApTableRowsId = mt.getId.wirelessMeshApTableRowsId(index);

					var temp = 	"<div id='" + (index == 0 ? "div_please_wait_for_process" : "div_please_wait_for_process_" + index) + "' class='textCenter'>";
					temp += 	"	<span id='" + (index == 0 ? "__ML_wireless_operating_mode_ap_searching_message" : "__ML_wireless_operating_mode_ap_searching_message_" + index) + "' ml='__ML_wireless_operating_mode_ap_searching_message' class='large'></span>";
					temp += 	"	<br /><img src='/images/ajax-loader3.gif' alt='Please wait.' border='0' />";
					temp += 	"</div>";
					temp +=		"<div id='" + instance.wirelessMeshApTableId + "'>";
					temp +=		"<div class='textCenter'><span id='__ML_wireless_neighbouring_ap_list' ml='__ML_wireless_neighbouring_ap_list' class='large'></span></div>";
					temp += 	"<div class='wirelessMeshApTableDiv'>";
					temp += 	"	<table id='" + (index == 0 ? "apTable" : "apTable_" + index) + "' class='marginCenter widthAuto'>";
					temp +=		"		<thead>";
					temp +=		"			<tr>";
					temp +=		"				<th>";
					temp +=		"					<span id='" + (index == 0 ? "__ML_add" : "__ML_add" + index) + "' ml='__ML_add'></span>";
					temp +=		"				</th>";
					temp +=		"				<th>";
					temp +=		"					<span id='" + (index == 0 ? "__ML_wireless_bssid_mac_address" : "__ML_wireless_bssid_mac_address" + index) + "' ml='__ML_wireless_bssid_mac_address'></span>";
					temp +=		"				</th>";

					temp +=		"				<th>";
					temp +=		"					<span id='" + (index == 0 ? "wireless_ssid" : "wireless_ssid" + index) + "'>SSID</span>";
					temp +=		"				</th>";

					temp +=		"				<th>";
					temp +=		"					<span id='" + (index == 0 ? "__ML_channel" : "__ML_channel" + index) + "' ml='__ML_channel'></span>";
					temp +=		"				</th>";
					temp +=		"				<th>";
					temp +=		"					<span id='" + (index == 0 ? "__ML_mode" : "__ML_mode" + index) + "' ml='__ML_mode'></span>";
					temp +=		"				</th>";
					temp +=		"				<th>";
					temp +=		"					<span id='" + (index == 0 ? "__ML_security" : "__ML_security" + index) + "' ml='__ML_security'></span>";
					temp +=		"				</th>";
					temp +=		"				<th>";
					temp +=		"					<span id='" + (index == 0 ? "__ML_wireless_signal_level" : "__ML_wireless_signal_level" + index) + "' ml='__ML_wireless_signal_level'></span>";
					temp +=		"				</th>";
					temp +=		"			</tr>";
					temp +=		"		</thead>";
					temp += 	"		<tbody id='"+instance.wirelessMeshApTableRowsId+"'></tbody>";
					temp += 	"	</table>";
					temp += 	"</div>";
					temp += 	"</div>";

					mt.wirelessDiv.append(temp);
				}
			},

			set: {
			},

			get: {
				wdsEnabled: function(index, wds_index)
				{
					return $("#" + wirelessMeshView.managerTab.getId.wdsTableEnabledControlId(index, wds_index)).is(":checked");
				}
			},

			getId: {
				wdsTableTbodyId: function(index)
				{
					if(index > 0)
					{
						return "wdsRows_<index>".replace("<index>", index);
					}
					else
					{
						return "wdsRows";
					}
				},

				wdsTableEnabledControlId: function(index, wds_index)
				{
					if(index > 0)
					{
						return "cb2_<index>_<wds_index>".replace("<index>", index).replace("<row>", wds_index);
					}
					else
					{
						return "cb2_<wds_index>".replace("<wds_index>", wds_index);
					}
				},

				wdsTableMacAddressLabelId: function(index,wds_index)
				{
					if(index > 0)
					{
						return "meshListMacAddress_<index>_<wds_index>".replace("<index>", index).replace("<wds_index>", wds_index);
					}
					else
					{
						return "meshListMacAddress<wds_index>".replace("<wds_index>", wds_index);
					}
				},

				wdsTableDeleteButtonId: function(index,wds_index)
				{
					if(index > 0)
					{
						return "btn_<index>_<wds_index>".replace("<index>", index).replace("<wds_index>", wds_index);
					}
					else
					{
						return "btn_<wds_index>".replace("<wds_index>", wds_index);
					}
				},

				apTableIsExistButtonId: function(index,ap_index)
				{
					if(index > 0)
					{
						return "cb_<index>_<ap_index>".replace("<index>", index).replace("<ap_index>", ap_index);
					}
					else
					{
						return "cb_<ap_index>".replace("<ap_index>", ap_index);
					}
				},

				apTableMacSpanId: function(index,ap_index)
				{
					if(index > 0)
					{
						return "mac_<index>_<ap_index>".replace("<index>", index).replace("<ap_index>", ap_index);
					}
					else
					{
						return "mac<ap_index>".replace("<ap_index>", ap_index);
					}
				},

				apTableSsidSpanId: function(index,ap_index)
				{
					if(index > 0)
					{
						return "ssid_<index>_<ap_index>".replace("<index>", index).replace("<ap_index>", ap_index);
					}
					else
					{
						return "ssid<ap_index>".replace("<ap_index>", ap_index);
					}
				},

				apTableChannelSpanId: function(index,ap_index)
				{
					if(index > 0)
					{
						return "channel_<index>_<ap_index>".replace("<index>", index).replace("<ap_index>", ap_index);
					}
					else
					{
						return "channel<ap_index>".replace("<ap_index>", ap_index);
					}
				},

				apTableModeSpanId: function(index,ap_index)
				{
					if(index > 0)
					{
						return "mode_<index>_<ap_index>".replace("<index>", index).replace("<ap_index>", ap_index);
					}
					else
					{
						return "mode<ap_index>".replace("<ap_index>", ap_index);
					}
				},

				apTableSecuritySpanId: function(index,ap_index)
				{
					if(index > 0)
					{
						return "security_<index>_<ap_index>".replace("<index>", index).replace("<ap_index>", ap_index);
					}
					else
					{
						return "security<ap_index>".replace("<ap_index>", ap_index);
					}
				},

				apTableRssiSpanId: function(index,ap_index)
				{
					if(index > 0)
					{
						return "rssi_<index>_<ap_index>".replace("<index>", index).replace("<ap_index>", ap_index);
					}
					else
					{
						return "rssi<ap_index>".replace("<ap_index>", ap_index);
					}
				},

				searchApButtonId: function(index)
				{
					if(index > 0)
					{
						return "__ML_search_ap_<index>".replace("<index>", index);
					}
					else
					{
						return "__ML_search_ap";
					}
				},

				addConnectionSpanId: function(index)
				{
					if(index > 0)
					{
						return "__ML_wireless_add_connection_label_<index>".replace("<index>", index);
					}
					else
					{
						return "__ML_wireless_add_connection_label";
					}
				},

				addConnectionControlId: function(index)
				{
					if(index > 0)
					{
						return "mac_address_<index>".replace("<index>", index);
					}
					else
					{
						return "mac_address";
					}
				},

				addConnectionButtonId: function(index)
				{
					if(index > 0)
					{
						return "__ML_add_<index>".replace("<index>", index);
					}
					else
					{
						return "__ML_add";
					}
				},

				wirelessMeshApTableId: function(index)
				{
					if(index > 0)
					{
						return "wirelessMeshApTable_<index>".replace("<index>", index);
					}
					else
					{
						return "wirelessMeshApTable";
					}
				},

				wirelessMeshApTableRowsId: function(index)
				{
					if(index > 0)
					{
						return "apRows_<index>".replace("<index>", index);
					}
					else
					{
						return "apRows";
					}
				}

			},

			addPageValidations: function(index)
			{
		    	var validationObj = {
		    			"elementId": wirelessMeshView.instances[index].addConnectionControlId,
		    			"label": globalView.getMultiLanguageText('__ML_mac_address_lower_case'),
		    			"groups": "addWds",
		    			"type":{
		    				"Required":{},
		    				"Pattern": {
		    					"regex":"^([0-9a-fA-F]{2}(\:)){5}[0-9a-fA-F]{2}$",
		    					"format":"0E:45:65:AA:B0:F0"},
		    				"MacValidation": {}
		    				}
		    	};

		    	globalView.addRegulaValidation(validationObj);
			},

			addTab: function(index)
			{

				wirelessMeshView.managerTab.managerTabId = "tabs-" + index;

				wirelessMeshView.managerTab.managerTab = $("<div id='" + wirelessMeshView.managerTab.managerTabId + "'></div>").appendTo("#tabs");

				wirelessMeshView.managerTab.wirelessDiv = $("<div id='wirelessDiv" + index + "' class='wirelessMesh'></div>").appendTo(wirelessMeshView.managerTab.managerTab);

				var instance = wirelessMeshView.instances[index];
				var selectedFreq = instance.configSettings.freq;
				var selectedFreqName = instance.freqs[selectedFreq].text;

				if(wirelessMeshView.instances.length <= 1)
					$("#managerSelectorUl").hide();
				else
					$("#managerSelectorUl").append("<li id='tab_" + index + "'><a href='#tabs-" + index + "'>" + globalView.getMultiLanguageText('__ML_wireless_network_lan') + " " + (index + 1) + " (" + selectedFreqName + ")</a></li>");
					//$("#managerSelectorUl").append("<li id='tab_" + index + "'><a href='#tabs-" + index + "'>" + globalView.getMultiLanguageText('__ML_wireless_network_lan') + " " + (index+1) + "</a></li>");

				if(wirelessMeshModel.instances[index].configSettings.opMode != "sta")
				{
					var secMode = wirelessMeshView.instances[index].aps[0].sec_mode; // First AP of the instance which is mesh.
					if(__DEF_Accept_wpa == 0 && (secMode == "wpa_both" || secMode == "wpa2"))
					{
						wirelessMeshView.managerTab.addRow.wpaWarning(index);
					}
					else
					{
						wirelessMeshView.managerTab.addRow.searchApButton(index);

						wirelessMeshView.managerTab.addRow.apTable(index);

						wirelessMeshView.managerTab.addRow.wdsTable(index);
						wirelessMeshView.managerTab.addRow.wdsTableTbody(index);
						wirelessMeshView.managerTab.addRow.addConnection(index);

						$("#" + (index == 0 ? "div_please_wait_for_process" : "div_please_wait_for_process_" + index)).hide();

						$("#" + wirelessMeshView.instances[index].wirelessMeshApTableId).hide();
					}

					wirelessMeshView.managerTab.addPageValidations(index);
				}
				else
				{
					wirelessMeshView.managerTab.addRow.staWarning(index);
				}
			}
		},

		actions:
		{
			addMacButtonClicked: function(index)
			{
				var instance = wirelessMeshView.instances[index];
				if(globalController.validateObjects("addWds"))
				{
					wirelessMeshView.addWds(index, $('#'+ instance.addConnectionControlId).val());
				}
			},

			wdsTableEnabledControlClicked: function(index, wds_index)
			{
				wirelessMeshView.instances[index].wds_list[wds_index].enabled = wirelessMeshView.managerTab.get.wdsEnabled(index, wds_index);
			},

			wdsTableDeleteButtonClicked: function(index, wds_index)
			{
				var instance = wirelessMeshView.instances[index];
				var mt = wirelessMeshView.managerTab;

				instance.wds_list[wds_index].removed = true;

				var ap_list = wirelessMeshModel.instances[index].ap_scan.ap_list;
				for(var i = 0; i<ap_list.length; i++)
				{
					if(ap_list[i].mac == instance.wds_list[wds_index].mac)
					{
						$("#"+ mt.getId.apTableIsExistButtonId(index, i)).removeAttr("checked");
					}
				}

				mt.addRow.wdsTableTbody(index);
			},

			searchApButtonClicked: function(index)
			{
				wirelessMeshController.sendApScanQuery(index);
			},

			apClicked: function(index, ap_index)
			{
				var instance = wirelessMeshView.instances[index];
				var mt = wirelessMeshView.managerTab;

				var ap_list = wirelessMeshModel.instances[index].ap_scan.ap_list;
				var secMode = wirelessMeshView.instances[index].aps[0].sec_mode;

				if($("#"+ mt.getId.apTableIsExistButtonId(index, ap_index)).is(":checked"))
				{
					if (__DEF_WirelessMeshMaxCount == wirelessMeshView.wdsCount(index))
					{
						$("#"+ mt.getId.apTableIsExistButtonId(index, ap_index)).removeAttr("checked");
						alert(globalView.getMultiLanguageText('__ML_wireless_mesh_max_wds_warning').replace("@max_wds_count@", __DEF_WirelessMeshMaxCount));
						return;
					}

					if(!wirelessMeshView.radarCheck(ap_list[ap_index].channel) || !wirelessMeshView.radarCheck(instance.configSettings.channel))
					{
						alert(globalView.getMultiLanguageText('__ML_wireless_mesh_radar_channel_warning').replace("@mesh_free_channels@", __DEF_radar_mesh_free_channels));
					}
					else if((parseInt(ap_list[ap_index].channel) > 35 ? "5000" : "2400") != instance.configSettings.freq)
					{
						alert(globalView.getMultiLanguageText('__ML_wireless_freq_conflict').replace("@freq@", (parseInt(ap_list[ap_index].channel)) > 35 ? "5" : "2.4").replace("@channel@", ap_list[ap_index].channel));
					}
					else if(!wirelessMeshView.checkSecurityMode(ap_list[ap_index].security, secMode) || ap_list[ap_index].channel != instance.configSettings.channel)
					{
						alert(globalView.getMultiLanguageText('__ML_wrong_sec_mode_channel'));
					}

					return(wirelessMeshView.addWds(index, ap_list[ap_index].mac));

				}
				else
				{
					wirelessMeshView.removeWdsByMac(index, ap_list[ap_index].mac);
				}
			}
		},

		addWds: function(index, mac)
		{
			var instance = wirelessMeshView.instances[index];
			var wds_list = wirelessMeshModel.instances[index].wds_list;

			if (instance.maximumWdsLimit == wirelessMeshView.wdsCount(index))
			{
				alert(globalView.getMultiLanguageText('__ML_wireless_mesh_max_wds_warning').replace("@max_wds_count@", instance.maximumWdsLimit));
				return;
			}

			if(wirelessMeshView.isWdsExist(index, mac))
			{
				alert(globalView.getMultiLanguageText('__ML_mac_already_exists'));
				return;
			}

			wds_list.push({instance: "", enabled: true, mac: mac, removed: false});

			wirelessMeshView.managerTab.addRow.wdsTableTbody(index);

			return true;
		},

		removeWdsByMac: function(index, mac)
		{
			var wds_list = wirelessMeshModel.instances[index].wds_list;

			for(var i = 0; i < wds_list.length; i++)
			{
				if((wds_list[i].mac).toUpperCase() == mac.toUpperCase())
				{
					wirelessMeshView.actions.wdsTableDeleteButtonClicked(index, i);
				}
			}
		},

		isWdsExist: function(index, mac)
		{
			var wds_list = wirelessMeshModel.instances[index].wds_list;

			for(var i = 0; i < wds_list.length; i++)
			{
				if(wds_list[i].mac.toUpperCase() == mac.toUpperCase() && !wds_list[i].removed) return true;
			}
			return false;
		},

		checkSecurityMode: function(mode1, mode2)
		{
			var returnValue = false;
			mode1 = mode1.toUpperCase(); mode2 = mode2.toUpperCase();
			if(mode1 == mode2) returnValue = true;
			else if((mode1 == "WPA2" || mode1 == "WPA_BOTH") && (mode2 == "WPA2" || mode2 == "WPA_BOTH")) returnValue = true;
			return returnValue;
		},

		radarCheck: function(channel)
		{
			if(parseInt(channel) >= __DEF_radar_first_channel && parseInt(channel) <= __DEF_radar_last_channel) return false;
			else return true;
		},

		wdsCount: function(index)
		{
			var wds_list = wirelessMeshModel.instances[index].wds_list;

			var wdsCount = 0;
			for(var i = 0; i < wds_list.length; i++)
			{
				if(!wds_list[i].removed && wds_list[i].mac != "") wdsCount++;
			}
			return wdsCount;
		},

		buildApTable: function(index)
		{
			var instance = wirelessMeshView.instances[index];
			var mt = wirelessMeshView.managerTab;

			var ap_list = wirelessMeshModel.instances[index].ap_scan.ap_list;
			var wds_list = wirelessMeshModel.instances[index].wds_list;

			$("#" + wirelessMeshView.instances[index].wirelessMeshApTableRowsId).html("");
			var apRows = '';
			for(var i = 0; i<ap_list.length; i++)
			{
				instance.apTableIsExistButtonId = mt.getId.apTableIsExistButtonId(index, i);
				instance.apTableMacSpanId = mt.getId.apTableMacSpanId(index, i);
				instance.apTableSsidSpanId = mt.getId.apTableSsidSpanId(index, i);
				instance.apTableChannelSpanId = mt.getId.apTableChannelSpanId(index, i);
				instance.apTableModeSpanId = mt.getId.apTableModeSpanId(index, i);
				instance.apTableRssiSpanId = mt.getId.apTableRssiSpanId(index, i);

				var rssiImgValueTemplate = globalWireless.rssiStatus(ap_list[i].rssi);

				for(var j=0; j<wds_list.length; j++)
				{
					if(ap_list[i].mac == wds_list[j].mac) ap_list[i].exist= true;
				}

				apRows += '<tr '+ ((i%2) ? 'class="even"' : 'class="odd"' ) +'>';
				apRows += '	<td>';
				apRows += '		<input type="checkbox" id="'+instance.apTableIsExistButtonId+'" ' + (ap_list[i].exist ? '"checked="checked"' : "") + ' onclick="wirelessMeshView.actions.apClicked('+ index +','+ i +');" />';
				apRows += '	</td>';
				apRows += '	<td>';
				apRows += '		<span id="'+instance.apTableMacSpanId+'">'+ap_list[i].mac+'</span>';
				apRows += '	</td>';
				apRows += '	<td>';
				apRows += '		<span id="'+instance.apTableSsidSpanId+'">'+ap_list[i].ssid+'</span>';
				apRows += '	</td>';
				apRows += '	<td>';
				apRows += '		<span id="'+instance.apTableChannelSpanId+'">'+ap_list[i].channel+'</span>';
				apRows += '	</td>';
				apRows += '	<td>';
				apRows += '		<span id="'+instance.apTableModeSpanId+'">'+ap_list[i].protocol+'</span>';
				apRows += '	</td>';
				apRows += '	<td>';
				apRows += '		<span id="'+instance.apTableSecuritySpanId+'">'+globalWireless.securityType(ap_list[i].security)+'</span>';
				apRows += '	</td>';
				apRows += '	<td class="textCenter">';
				apRows += '		<span id="'+instance.apTableRssiSpanId+'">'+rssiImgValueTemplate+'</span>';
				apRows += '	</td>';
				apRows += '</tr>';

			}

			$("#" + wirelessMeshView.instances[index].wirelessMeshApTableRowsId).append(apRows);
		},

		addManagerTabs: function(managerCount)
		{
			$(".managerTab").remove();
			$(".footer").remove();

			$("#contentDiv").append("<div id='tabs' class='wirelessMeshTopDiv marginCenter'></div>");
			$("#tabs").append("<ul id='managerSelectorUl'></ul>");
			for(var i = 0; i < wirelessMeshView.instances.length; i++)
			{
				wirelessMeshView.managerTab.addTab(i);
			}
		},

		documentReady: function()
		{
			$("#contentDiv").html("");
			wirelessMeshView.addHedaerDiv();
			wirelessMeshView.addCommentDiv();
		},

		createTabControls: function(activeManagerIndex)
		{
			var $tabs = $('#tabs').tabs();

	        $tabs.tabs({
	            select: function(event, ui) {
	        		if(wirelessMeshView.confirmAndSetActiveManagerTab(ui.index))
	        		{
	        			wirelessMeshController.activeManagerIndex = ui.index;

	        			if(wirelessMeshModel.instances[wirelessMeshController.activeManagerIndex].configSettings.opMode == "sta")
	        			{
	        				$(".footer").hide();
	        			}
	        			else
	        			{
	        				$(".footer").show();
	        			}
	        		}
	        		else
	        		{
	        			return false;
	        		}
	        	}
	        });
	        
			if(wirelessMeshModel.instances[activeManagerIndex].configSettings.opMode == "sta")
			{
				$(".footer").hide();
			}
			else
			{
				$(".footer").show();
			}
	        
	        $tabs.tabs({ selected: activeManagerIndex });
		},

		confirmAndSetActiveManagerTab: function(index)
		{
			var changeTab = true;
			var changed = false;
			var instance = wirelessMeshView.instances[wirelessMeshController.activeManagerIndex];

			if($("#" + instance.addConnectionControlId).val() != "") changed = true;

			if(instance.wds_list.length != instance.wds_list_initial.length) changed = true;
			else
			{
				for(var i=0; i<instance.wds_list.length; i++)
				{
				    if(instance.wds_list[i].mac != instance.wds_list_initial[i].mac)
				    {
				    	changed = true;
				    	break;
				    }
				}
			}


			if(wirelessMeshController.activeManagerIndex == index) return false;

			if(changed)
			{
				if(confirm(globalView.getMultiLanguageText("__ML_wireless_settings_tab_change_confirm_message")))
				{
					instance.wds_list = instance.wds_list_initial;
					wirelessMeshView.managerTab.addRow.wdsTableTbody(wirelessMeshController.activeManagerIndex);
					$("#" + instance.addConnectionControlId).val("");
				}
				else
				{
					changeTab = false;
				}
			}

			return changeTab;
		},

		addHedaerDiv: function()
		{
			$("#contentDiv").append("<div class='textCenter title' id='headerDiv'></div>");
			$("#headerDiv").append("<span id='__ML_wireless_mesh_settings' ml='__ML_wireless_mesh_settings'></span>");
		},

		addCommentDiv: function()
		{
			$("#contentDiv").append("<div class='marginCenter globalHeaderInfoDiv' id='commentDiv'></div>");
			$("#commentDiv").html("");
			$("#commentDiv").append("<span id='__ML_wireless_mesh_settings_intro' ml='__ML_wireless_mesh_settings_intro'></span>");
		},

		addFooter: function()
		{
			var footer = $("<div class='footer'></div>");
			footer.append('<input type="button" id="__ML_save" ml="__ML_save" onclick="global.raiseEvent({eventHandler: \'wirelessMeshController\', id: \'saveClicked\'});"/>');
			footer.append('<input type="button" id="__ML_cancel" ml="__ML_cancel" onclick="global.raiseEvent({eventHandler: \'wirelessMeshController\', id: \'reloadPage\'});" />');
			footer.appendTo("#contentDiv");
		}
}