var wirelessMeshModel =
{
	eventHandler: function(args)
	{
		var index = 0; //args.index || args.instance_index || wirelessMeshController.activeManagerIndex;
		if(args.index != undefined) index = args.index;
		else if(args.instance_index != undefined) index = args.instance_index;
		else index = wirelessMeshController.activeManagerIndex;
		var ap_index = args.ap_index || 0;

		switch(args.id)
		{
			case "wirelessMeshModel.parseAPListQuery":
				wirelessMeshModel.parseAPListQuery();
				break;
			case "wirelessMeshModel.parseCapabilitiesQuery":
				wirelessMeshModel.parseCapabilitiesQuery();
				break;
			case "wirelessMeshModel.parseChannelQuery":
				wirelessMeshModel.parseChannelQuery();
				break;
			case "wirelessMeshModel.parseFreqQuery":
				wirelessMeshModel.parseFreqQuery();
				break;
			case "wirelessMeshModel.parseInstListQuery":
				wirelessMeshModel.parseInstListQuery();
				break;
			case "wirelessMeshModel.parseOpModeQuery":
				wirelessMeshModel.parseOpModeQuery();
				break;
			case "wirelessMeshModel.parseSecurityValuesQuery":
				wirelessMeshModel.parseSecurityValuesQuery();
				break;
			case "wirelessMeshModel.parseWDSListQuery":
				wirelessMeshModel.parseWDSListQuery();
				break;
			case "wirelessMeshModel.parseWDSPropertiesQuery":
				wirelessMeshModel.parseWDSPropertiesQuery();
				break;
			case "saveFinished":
				if(typeof wirelessMeshModel.instances[index].saveWDSPropertiesQuery2 == "function")
				{
					wirelessMeshModel.save2(index);
				}
				else
				{
					wirelessMeshModel.save5(index);
				}
				break;
			case "save2Finished":
				wirelessMeshModel.save3(index);
				break;
			case "save3Finished":
				wirelessMeshModel.save4(index);
				break;
			case "save4Finished":
				wirelessMeshModel.save3(index);
				break;
		}
	},

	instances: [],
	parseAPListQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.parseAPListQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMeshModel.instances.length; i++)
			{
				wirelessMeshModel.instances[i].parseAPListQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMeshModel.parseAPListQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseCapabilitiesQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.parseCapabilitiesQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMeshModel.instances.length; i++)
			{
				wirelessMeshModel.instances[i].parseCapabilitiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMeshModel.parseCapabilitiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseChannelQuery: function()
	{
		for(var i = 0; i < wirelessMeshModel.instances.length; i++)
		{
			wirelessMeshModel.instances[i].parseChannelQuery();
		}
	},

	parseFreqQuery: function()
	{
		for(var i = 0; i < wirelessMeshModel.instances.length; i++)
		{
			wirelessMeshModel.instances[i].parseFreqQuery();
		}
	},

	parseInstListQuery: function()
	{
		wirelessMeshModel.instances = [];
		global.log({functionName: "wirelessMeshModel.parseInstListQuery", message: "called!", level: 100});
		if(top.xmlResponseObject["devmgr-0"]["wireless_core.inst0"]) wirelessMeshModel.instances.push(new wirelessCore("wireless_core-0"));
		var i = 0;
		while(top.xmlResponseObject["devmgr-0"]["wireless.inst" + i])
		{
			wirelessMeshModel.instances.push(new wirelessNg(top.xmlResponseObject["devmgr-0"]["wireless.inst" + i]));
			i++;
		}
	},

	parseOpModeQuery: function()
	{
		for(var i = 0; i < wirelessMeshModel.instances.length; i++)
		{
			wirelessMeshModel.instances[i].parseOpModeQuery();
		}
	},

	parseSecurityValuesQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.parseSecurityValuesQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMeshModel.instances.length; i++)
			{
				wirelessMeshModel.instances[i].parseSecurityValuesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMeshModel.parseSecurityValuesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseWDSListQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.parseWDSListQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMeshModel.instances.length; i++)
			{
				wirelessMeshModel.instances[i].parseWDSListQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMeshModel.parseWDSListQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseWDSPropertiesQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.parseWDSPropertiesQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMeshModel.instances.length; i++)
			{
				wirelessMeshModel.instances[i].parseWDSPropertiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMeshModel.parseWDSPropertiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	save: function(index)
	{
		wirelessMeshModel.instances[index].saveWDSPropertiesQuery();

		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "saveFinished", index: index});
		globalModel.sendAjax();
	},

	save2: function(index)
	{
		wirelessMeshModel.instances[index].saveWDSPropertiesQuery2();

		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "save2Finished", index: index});
		globalModel.sendAjax();
	},

	save3: function(index)
	{
		var finished = false;

		finished = wirelessMeshModel.instances[index].saveWDSPropertiesQuery3();

		if(finished == true)
		{
			wirelessMeshModel.save5(index);
		}
		else
		{
			globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "save3Finished", index: index});
			globalModel.sendAjax();
		}
	},

	save4: function(index)
	{

		wirelessMeshModel.instances[index].saveWDSPropertiesQuery4();

		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "save4Finished", index: index});
		globalModel.sendAjax();
	},

	save5: function(index)
	{
		wirelessMeshModel.instances[index].sendApply();
		globalModel.addEvent({eventHandler: "wirelessMeshController", id: "parseRebootRequiredQuery", index: index});
		globalModel.addEvent({eventHandler: "wirelessMeshController", id: "saved", index: index});
		globalModel.sendAjax();
	},

	sendAPListQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.sendAPListQuery", message: "called!", level: 100});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless_ap"});
		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "wirelessMeshModel.parseAPListQuery"});
	},

	sendCapabilitiesQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.sendCapabilitiesQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessMeshModel.instances.length; i++)
			{
				wirelessMeshModel.instances[i].sendCapabilitiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMeshModel.sendCapabilitiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "wirelessMeshModel.parseCapabilitiesQuery"});
	},

	sendChannelQuery: function()
	{
		for(var i = 0; i < wirelessMeshModel.instances.length; i++)
		{
			wirelessMeshModel.instances[i].sendChannelQuery();
		}
		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "wirelessMeshModel.parseChannelQuery"});
	},

	sendFreqQuery: function()
	{
		for(var i = 0; i < wirelessMeshModel.instances.length; i++)
		{
			wirelessMeshModel.instances[i].sendFreqQuery();
		}
		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "wirelessMeshModel.parseFreqQuery"});
	},

	sendInstListQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.sendInstListQuery", message: "called!", level: 100});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless_core"});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless"});
		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "wirelessMeshModel.parseInstListQuery"});
	},

	sendOpModeQuery: function()
	{
		for(var i = 0; i < wirelessMeshModel.instances.length; i++)
		{
			wirelessMeshModel.instances[i].sendOpModeQuery();
		}
		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "wirelessMeshModel.parseOpModeQuery"});
	},

	sendSecurityValuesQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.sendSecurityValuesQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessMeshModel.instances.length; i++)
			{
				wirelessMeshModel.instances[i].sendSecurityValuesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMeshModel.sendSecurityValuesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "wirelessMeshModel.parseSecurityValuesQuery"});
	},

	sendWDSListQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.sendWDSListQuery", message: "called!", level: 100});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless_wds"});
		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "wirelessMeshModel.parseWDSListQuery"});
	},

	sendWDSPropertiesQuery: function()
	{
		global.log({functionName: "wirelessMeshModel.sendWDSPropertiesQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessMeshModel.instances.length; i++)
			{
				wirelessMeshModel.instances[i].sendWDSPropertiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMeshModel.sendWDSPropertiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessMeshModel", id: "wirelessMeshModel.parseWDSPropertiesQuery"});
	}
}