var wirelessMeshController =
{
	activeManagerIndex: 0,
	activeManagerIndex1: 0,
	documentReady: function()
	{
		wirelessMeshView.documentReady();
		wirelessMeshController.sendFirstQuery();
	},

	eventHandler: function(args)
	{
		var index = 0; //args.index || args.instance_index || wirelessMeshController.activeManagerIndex;
		if(args.index != undefined) index = args.index;
		else if(args.instance_index != undefined) index = args.instance_index;
		else index = wirelessMeshController.activeManagerIndex;
		var ap_index = args.ap_index || 0;

		switch(args.id)
		{
			case "wirelessMeshController.firstQueryFinished":
				wirelessMeshController.sendSecondQuery();
				break;
			case "wirelessMeshController.secondQueryFinished":
				wirelessMeshController.sendThirdQuery();
				break;
			case "wirelessMeshController.thirdQueryFinished":
				wirelessMeshController.sendFourthQuery();
				break;
			case "wirelessMeshController.fourthQueryFinished":
				wirelessMeshController.allQueriesFinished();
				break;
			case "wirelessMeshController.apScanQuerySent":
				//wirelessMeshModel.instances[index].parseApScanQuery();
				setTimeout("wirelessMeshController.sendApScanStatusQuery(" + index + ")", "3000");
				//wirelessMeshController.sendApScanStatusQuery(index);
				break;
			case "wirelessMeshController.apScanStatusQuerySent":
				wirelessMeshModel.instances[index].parseApScanStatusQuery();
				if(wirelessMeshModel.instances[index].ap_scan.status == "ok")
				{
					wirelessMeshController.sendApScanResultQuery(index, 0);
				}
				else
				{
					setTimeout("wirelessMeshController.sendApScanStatusQuery(" + index + ")", "3000");
				}
				break;
			case "wirelessMeshController.apScanResultQuerySent":
				var counter = wirelessMeshModel.instances[index].ap_scan.ap_list.length;
				wirelessMeshModel.instances[index].parseApScanResultQuery(counter);
				if(wirelessMeshModel.instances[index].ap_scan.ap_requery != "0")
				{
					wirelessMeshController.sendApScanResultQuery(index, wirelessMeshModel.instances[index].ap_scan.ap_list.length);
				}
				else
				{
					if(wirelessMeshModel.instances[index].ap_scan.ap_list.length > 0)
					{
						$("#" + wirelessMeshView.instances[index].wirelessMeshApTableId).show();
						wirelessMeshView.buildApTable(index);
					}
					else
					{
						// Display No Ap Message
					}
					$("#" + (index == 0 ? "div_please_wait_for_process" : "div_please_wait_for_process_" + index)).hide();
					$("#"+ ((index == 0) ? "apTable" : "apTable_" + index)).show();
				}
				break;
			case "saveClicked":
				wirelessMeshView.instances[wirelessMeshController.activeManagerIndex].beSaved = true;
				wirelessMeshController.save(index);
				break;
			case "saved":
				if(wirelessMeshView.instances[wirelessMeshController.activeManagerIndex].requiresReboot) global.reboot();
				wirelessMeshController.activeManagerIndex1 = wirelessMeshController.activeManagerIndex;
				wirelessMeshView.createTabControls(0);
				page.documentReady();
				break;
			case "parseRebootRequiredQuery":
				wirelessMeshModel.instances[index].parseRebootRequiredQuery();
				break;
			case "reloadPage":
				window.location.href = "/wireless/mesh/mesh_new.html";
				break;
		}
	},

	allQueriesFinished: function()
	{
		for(var i = 0; i < wirelessMeshModel.instances.length; i++)
		{
			if(wirelessMeshModel.instances[i].meshExist == false)
			{
				wirelessMeshModel.instances.splice(i,1);
			}
		}

		wirelessMeshView.instances = wirelessMeshModel.instances.slice();
		wirelessMeshView.addManagerTabs();
		wirelessMeshView.addFooter();
		wirelessMeshView.createTabControls(wirelessMeshController.activeManagerIndex1); // It must be located after adding footer.


		for(var i = 0; i < wirelessMeshView.instances.length; i++)
		{
			wirelessMeshView.instances[i].wds_list_initial = wirelessMeshModel.instances[i].wds_list.slice();
		}

		globalView.addButtonClass();

		globalView.showPage();
	},

	getWirelessInstances: function()
	{
		wirelessMeshModel.sendInstListQuery();
	},

	sendFirstQuery: function()
	{
		wirelessMeshController.getWirelessInstances();
		globalModel.addEvent({eventHandler: "wirelessMeshController", id: "wirelessMeshController.firstQueryFinished"});
		globalModel.sendAjax();
	},

	sendSecondQuery: function()
	{
		wirelessMeshModel.sendCapabilitiesQuery();
		globalModel.addEvent({eventHandler: "wirelessMeshController", id: "wirelessMeshController.secondQueryFinished"});
		globalModel.sendAjax();
	},

	sendThirdQuery: function()
	{
		wirelessMeshModel.sendAPListQuery();
		wirelessMeshModel.sendWDSListQuery();
		globalModel.addEvent({eventHandler: "wirelessMeshController", id: "wirelessMeshController.thirdQueryFinished"});
		globalModel.sendAjax();
	},

	sendFourthQuery: function()
	{
		wirelessMeshModel.sendSecurityValuesQuery();
		wirelessMeshModel.sendChannelQuery();
		wirelessMeshModel.sendFreqQuery();
		wirelessMeshModel.sendWDSPropertiesQuery();
		wirelessMeshModel.sendOpModeQuery();
		globalModel.addEvent({eventHandler: "wirelessMeshController", id: "wirelessMeshController.fourthQueryFinished"});
		globalModel.sendAjax();
	},

	save: function(index)
	{
		globalView.disablePage();

		if(wirelessMeshView.instances[index].beSaved)
		{
			wirelessMeshModel.save(index);
		}
	},

	sendApScanQuery: function(index)
	{
		$("#"+ ((index == 0) ? "apTable" : "apTable_" + index)).hide();
		$("#" + (index == 0 ? "div_please_wait_for_process" : "div_please_wait_for_process_" + index)).show();
		wirelessMeshModel.instances[index].sendStartApScanQuery();
		globalModel.addEvent({eventHandler: "wirelessMeshController", id: "wirelessMeshController.apScanQuerySent", index: index});
		globalModel.sendAjax();
	},

	sendApScanStatusQuery: function(index)
	{
		wirelessMeshModel.instances[index].sendApScanStatusQuery();
		globalModel.addEvent({eventHandler: "wirelessMeshController", id: "wirelessMeshController.apScanStatusQuerySent", index: index});
		globalModel.sendAjax();
	},

	sendApScanResultQuery: function(index, counter)
	{
		wirelessMeshModel.instances[index].sendApScanResultQuery(counter);
		globalModel.addEvent({eventHandler: "wirelessMeshController", id: "wirelessMeshController.apScanResultQuerySent", index: index});
		globalModel.sendAjax();
	}

}
