var wirelessMacModel =
{
	eventHandler: function(args)
	{
		switch(args.id)
		{
			case "wirelessMacModel.parseApAclListQuery":
				wirelessMacModel.parseApAclListQuery();
				break;
			case "wirelessMacModel.parseApAclModeQuery":
				wirelessMacModel.parseApAclModeQuery();
				break;
			case "wirelessMacModel.parseApEnabledQuery":
				wirelessMacModel.parseApEnabledQuery();
				break;
			case "wirelessMacModel.parseAPListQuery":
				wirelessMacModel.parseAPListQuery();
				break;
			case "wirelessMacModel.parseApStaListQuery":
				wirelessMacModel.parseApStaListQuery();
				break;
			case "wirelessMacModel.parseCapabilitiesQuery":
				wirelessMacModel.parseCapabilitiesQuery();
				break;
			case "wirelessMacModel.parseFreqQuery":
				wirelessMacModel.parseFreqQuery();
				break;
			case "wirelessMacModel.parseInstListQuery":
				wirelessMacModel.parseInstListQuery();
				break;
		}
	},

	instances: [],

	parseApAclListQuery: function()
	{
		global.log({functionName: "wirelessMacModel.parseApAclListQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].parseApAclListQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.parseApAclListQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseApAclModeQuery: function()
	{
		global.log({functionName: "wirelessMacModel.parseApAclModeQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].parseApAclModeQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.parseApAclModeQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseApEnabledQuery: function()
	{
		global.log({functionName: "wirelessMacModel.parseApEnabledQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].parseApEnabledQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.parseApEnabledQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseApStaListQuery: function()
	{
		global.log({functionName: "wirelessMacModel.parseApStaListQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].parseApStaListQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.parseApStaListQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseAPListQuery: function()
	{
		global.log({functionName: "wirelessMacModel.parseAPListQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].parseAPListQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.parseAPListQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseCapabilitiesQuery: function()
	{
		global.log({functionName: "wirelessMacModel.parseCapabilitiesQuery", message: "called!", level: 100});
		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].parseCapabilitiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.parseCapabilitiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}
	},

	parseFreqQuery: function()
	{
		for(var i = 0; i < wirelessMacModel.instances.length; i++)
		{
			wirelessMacModel.instances[i].parseFreqQuery();
		}
	},

	parseInstListQuery: function()
	{
		wirelessMacModel.instances = [];
		if(top.xmlResponseObject["devmgr-0"]["wireless_core.inst0"]) wirelessMacModel.instances.push(new wirelessCore("wireless_core-0"));
		var i = 0;
		while(top.xmlResponseObject["devmgr-0"]["wireless.inst" + i])
		{
			wirelessMacModel.instances.push(new wirelessNg(top.xmlResponseObject["devmgr-0"]["wireless.inst" + i]));
			i++;
		}
	},

	sendInstListQuery: function()
	{
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless_core"});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless"});
		globalModel.addEvent({eventHandler: "wirelessMacModel", id: "wirelessMacModel.parseInstListQuery"});
	},

	sendApAclListQuery: function()
	{
		global.log({functionName: "wirelessMacModel.sendApAclListQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].sendApAclListQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.sendApAclListQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessMacModel", id: "wirelessMacModel.parseApAclListQuery"});
	},

	sendApAclModeQuery: function()
	{
		global.log({functionName: "wirelessMacModel.sendApAclModeQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].sendApAclModeQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.sendApAclModeQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessMacModel", id: "wirelessMacModel.parseApAclModeQuery"});
	},

	sendApEnabledQuery: function()
	{
		global.log({functionName: "wirelessMacModel.sendApEnabledQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].sendApEnabledQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.sendApEnabledQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessMacModel", id: "wirelessMacModel.parseApEnabledQuery"});
	},

	sendApStaListQuery: function()
	{
		global.log({functionName: "wirelessMacModel.sendApStaListQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].sendApStaListQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.sendApStaListQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessMacModel", id: "wirelessMacModel.parseApStaListQuery"});
	},

	sendAPListQuery: function()
	{
		global.log({functionName: "wirelessMacModel.sendAPListQuery", message: "called!", level: 100});
		globalModel.addQuery({instance: "devmgr-0", key: "inst_list", value: "wireless_ap"});
		globalModel.addEvent({eventHandler: "wirelessMacModel", id: "wirelessMacModel.parseAPListQuery"});
	},

	sendCapabilitiesQuery: function()
	{
		global.log({functionName: "wirelessMacModel.sendCapabilitiesQuery", message: "called!", level: 100});

		try
		{
			for(var i = 0; i < wirelessMacModel.instances.length; i++)
			{
				wirelessMacModel.instances[i].sendCapabilitiesQuery();
			}
		}
		catch(e)
		{
			global.log({functionName: "wirelessMacModel.sendCapabilitiesQuery", message: "ERROR!<error>".replace("<error>", e.message), level: 100});
		}

		globalModel.addEvent({eventHandler: "wirelessMacModel", id: "wirelessMacModel.parseCapabilitiesQuery"});
	},
	
	sendFreqQuery: function()
	{
		for(var i = 0; i < wirelessMacModel.instances.length; i++)
		{
			wirelessMacModel.instances[i].sendFreqQuery();
		}
		globalModel.addEvent({eventHandler: "wirelessMacModel", id: "wirelessMacModel.parseFreqQuery"});
	},

}