var Model = function() {
	this.ready = new Event();
	this.init();
};

Model.prototype.init = function() {
	this.refreshData();
};

Model.prototype.parseVpnInstances = function() {
	this.vpnInstances = {};
	var i = 0;
	while(getValue("devmgr-0", "vpn.inst" + i) != "") {
		this.vpnInstances[getValue("devmgr-0", "vpn.inst" + i)] = {};
		i++;
	}
	this.sendVpnQuery();
};

Model.prototype.parseVpnQuery = function() {
	for(var key in this.vpnInstances) {
		this.vpnInstances[key].server = getValue(key, "server");
		this.vpnInstances[key].status = getValue(key, "status");
	}
	this.ready.notify();
};

Model.prototype.refreshData = function() {
	beginXML();
	addQuery("devmgr-0", "inst_list", "vpn");
	endXML();
	var self = this;
	sendAJAX(function() {
		self.parseVpnInstances();
	});
};

Model.prototype.save = function() {
	beginXML();
	for(var key in this.vpnInstances) {
		addCommand("cfgmgr-0", "begin_transaction", key);
		addSet(key, "server", this.vpnInstances[key].server);
		addCommand("cfgmgr-0", "end_transaction", key);
	}
	addCommand("cfgmgr-0", "save");
	endXML();
	var self = this;
	sendAJAX(function() {
		self.refreshData();
	});
};

Model.prototype.sendVpnQuery = function() {
	beginXML();
	for(var key in this.vpnInstances) {
		addCommand("cfgmgr-0", "begin_transaction", key);
		addGet(key, "server", "");
		addQuery(key, "status", "");
		addCommand("cfgmgr-0", "end_transaction", key);
	}
	endXML();
	var self = this;
	sendAJAX(function() {
		self.parseVpnQuery();
	});
};
