var Model = function(inst) {
	this.inst = inst || "";
	this.ready = new Event();
	this.init();
};

Model.prototype.init = function() {
	this.refreshData();
};
Model.prototype.parseFirstQuery = function() {
	this.server = getValue(this.inst, "server");
	this.enabled = getValue(this.inst, "enabled") == "1";
	this.status = getValue(this.inst, "status");
	this.username = getValue(this.inst, "username-0");
	this.password = getValue(this.inst, "password-0");
	this.mtu = getValue(this.inst, "mtu");
	this.refuse_pap = getValue(this.inst, "refuse-pap") == "1";
	this.refuse_eap = getValue(this.inst, "refuse-eap") == "1";
	this.require_mppe_128 = getValue(this.inst, "require-mppe-128") == "1";
	this.routeAllTrafficThroughVpn = getValue(this.inst, "defaultroute") == "2";
	this.usepeerdns = getValue(this.inst, "usepeerdns") == "1";

	this.initialValues = {
		server : this.server,
		enabled : this.enabled,
		username : this.username,
		password : this.password,
		mtu : this.mtu,
		refuse_pap : this.refuse_pap,
		refuse_eap : this.refuse_eap,
		require_mppe_128 : this.require_mppe_128,
		routeAllTrafficThroughVpn : this.routeAllTrafficThroughVpn,
		usepeerdns : this.usepeerdns
	};

	this.wanList = {};
	this.pvcList = {};
	this.wanVlanList = {};

	var i = 0;
	while(getValue("devmgr-0", "wan.inst" + i) != "") {
		this.wanList[getValue("devmgr-0", "wan.inst" + i)] = {
			"name" : ""
		};
		i++;
	}

	var i = 0;
	while(getValue("devmgr-0", "pvc.inst" + i) != "") {
		this.pvcList[getValue("devmgr-0", "pvc.inst" + i)] = {
			"name" : ""
		};
		i++;
	}

	var i = 0;
	while(getValue("devmgr-0", "wan_vlan.inst" + i) != "") {
		this.wanVlanList[getValue("devmgr-0", "wan_vlan.inst" + i)] = {
			"name" : ""
		};
		i++;
	}
	this.sendSecondQuery();
};

Model.prototype.parseSecondQuery = function() {
	$.each(this.pvcList, function(key, pvc) {
		pvc.name = getValue(key, "name");
	});

	$.each(this.wanVlanList, function(key, wanVlan) {
		wanVlan.name = getValue(key, "name");
	});

	var self = this;
	$.each(this.wanList, function(key, wan) {
		if(self.pvcList[getValue(key, "entities.pvc")]) {
			wan.name = self.pvcList[getValue(key, "entities.pvc")].name;
		} else if(self.wanVlanList[getValue(key, "entities.wan_vlan")]) {
			wan.name = self.wanVlanList[getValue(key, "entities.wan_vlan")].name;
		} else {
			wan.name = "-";
		}
	});

	this.ready.notify();
};

Model.prototype.refreshData = function() {
	this.sendFirstQuery();
};

Model.prototype.sendFirstQuery = function() {
	var inst = this.inst;
	beginXML();
	addCommand("cfgmgr-0", "begin_transaction", inst);
	addGet(inst, "server", "");
	addGet(inst, "enabled", "");
	addGet(inst, "username-0", "");
	addGet(inst, "password-0", "");
	addGet(inst, "mtu", "");
	addGet(inst, "defaultroute", "");
	addGet(inst, "alloptions", "");
	addCommand("cfgmgr-0", "end_transaction", inst);
	addQuery("devmgr-0", "inst_list", "wan");
	addQuery("devmgr-0", "inst_list", "pvc");
	addQuery("devmgr-0", "inst_list", "wan_vlan");
	endXML();
	var self = this;
	sendAJAX(function() {
		self.parseFirstQuery();
	});
};

Model.prototype.sendSecondQuery = function() {
	beginXML();

	$.each(this.wanList, function(key) {
		addCommand("cfgmgr-0", "begin_transaction", key);
		addGet(key, "entities", "");
		addCommand("cfgmgr-0", "end_transaction", key);
	});

	$.each(this.pvcList, function(key) {
		addCommand("cfgmgr-0", "begin_transaction", key);
		addGet(key, "name", "");
		addCommand("cfgmgr-0", "end_transaction", key);
	});

	$.each(this.wanVlanList, function(key) {
		addCommand("cfgmgr-0", "begin_transaction", key);
		addGet(key, "name", "");
		addCommand("cfgmgr-0", "end_transaction", key);
	});

	endXML();
	
	var self = this;

	sendAJAX(function() {
		self.parseSecondQuery();
	});
};

Model.prototype.save = function() {
	beginXML();
	addCommand("cfgmgr-0", "begin_transaction", this.inst);
	addSet(this.inst, "server", this.server);
	addSet(this.inst, "enabled", this.enabled ? "1" : "0");
	addSet(this.inst, "username-0", this.username);
	addSet(this.inst, "password-0", this.password);
	addSet(this.inst, "mtu", this.mtu);
	addSet(this.inst, "defaultroute", (this.routeAllTrafficThroughVpn ? "2" : "0"));
	addSet(this.inst, "setoption", "refuse-pap:" + (this.refuse_pap ? "1" : "0"));
	addSet(this.inst, "setoption", "refuse-eap:" + (this.refuse_eap ? "1" : "0"));
	addSet(this.inst, "setoption", "require-mppe-128:" + (this.require_mppe_128 ? "1" : "0"));
	addSet(this.inst, "setoption", "usepeerdns:" + (this.usepeerdns ? "1" : "0"));
	addCommand("cfgmgr-0", "commit", this.inst);
	addCommand("cfgmgr-0", "end_transaction", this.inst);
	addCommand("cfgmgr-0", "save");
	endXML();
	
	var rebootRequired = false;
	var self = this;
	
	$.each(this.initialValues, function(key, value){
		if(value != self[key]) {
			rebootRequired = true;
		}
	});
	
	var callback = rebootRequired ? global.reboot : function(){self.refreshData()};
	sendAJAX(callback);
};

