var Model = function() {
	this.modulationList = {};
	this.modulationIdList = {};
	this.port = 4;
	this.ready = new Event();
	this.init();
};

Model.prototype.init = function() {
	this.port = __DEF_EthDefaultPort || 4;
	this.refreshData();
};

Model.prototype.parseQuery = function() {
	this.modulationValue = getValue("dsl-0", "xdsl_config");
	this.modulationList = $.parseJSON(this.modulationValue);

	var counter = 0;
	for(var i in this.modulationList) {
		this.modulationIdList[i] = {
			id : "modulation_" + counter
		};
		counter++;
	}
	this.ready.notify();
};

Model.prototype.refreshData = function() {
	beginXML();
	addCommand("cfgmgr-0", "begin_transaction", "dsl-0");
	addGet("dsl-0", "xdsl_config", "");
	addCommand("cfgmgr-0", "end_transaction", "dsl-0");
	endXML();
	var self = this;
	sendAJAX(function() {
		self.parseQuery();
	});
};

Model.prototype.save = function() {
	beginXML();
	addCommand("cfgmgr-0", "begin_transaction", "dsl-0");
	addSet("dsl-0", "xdsl_config", JSON.stringify(this.modulationList));
	addCommand("cfgmgr-0", "commit", "dsl-0");
	addCommand("cfgmgr-0", "end_transaction", "dsl-0");
	addCommand("cfgmgr-0", "save");
	addCommand("dsl-0", "apply");
	endXML();
	var self = this;
	sendAJAX(function() {
		self.refreshData();
	});
};
