function WanList() {
	var self = this;
	var data = {
		isReady : false,
		list : []
	};

	self.checkState = function() {
		data.isReady = $.grep(data.list, function(wan) {
			return !wan.isReady();
		}).length == 0;
		if (data.isReady) {
			$(self).trigger("ready");
		}
	};

	function add(_wan) {
		data.list.push(_wan);
	}

	function load() {
		globalModel.addQuery({
			instance : "devmgr-0",
			key : "inst_list",
			value : "wan"
		});

		$(globalModel).bind("queryFinished", resumeLoad);

		globalModel.sendAjax();
	}

	function resumeLoad(event, _data) {
		$(globalModel).off("queryFinished", resumeLoad);
		var i = 0;
		while (_data["devmgr-0"]["wan.inst" + i]) {
			var wan = new Wan(_data["devmgr-0"]["wan.inst" + i]);
			$(wan).bind("ready", self.checkState);
			add(wan);
			i++;
		}
	}


	globalModel.runWhenPossible(load);

	self.getList = function() {
		return data.list;
	}

	self.getWan = function(index) {
		return data.list[index];
	}

	self.isReady = function() {
		return data.isReady;
	}
}

function Wan(instance) {
	var self = this;
	var data = {
		isReady : false,
		instance : instance,
		entities : {},
		name : "",
	}

	function load() {
		globalModel.addQuery({
			instance : data.instance,
			key : "entities"
		});

		$(globalModel).bind("queryFinished", self.resumeLoad);

		globalModel.sendAjax();
	};

	self.resumeLoad = function(event, _data) {
		$(globalModel).off("queryFinished", self.resumeLoad);
		if (_data[data.instance]["entities.pvc"] != undefined) {
			var pvc = new Pvc(_data[data.instance]["entities.pvc"]);
			$(pvc).bind("ready", self.checkState);
			self.setPvc(pvc);
		}

		if (_data[data.instance]["entities.wan_vlan"] != undefined) {
			var wan_vlan = new Wan_vlan(_data[data.instance]["entities.wan_vlan"]);
			$(wan_vlan).bind("ready", self.checkState);
			self.setWan_vlan(wan_vlan);
		}

	}

	self.setPvc = function(pvc) {
		data.entities.pvc = pvc;
	};

	self.setWan_vlan = function(wan_vlan) {
		data.entities.wan_vlan = wan_vlan;
	};

	self.getPvc = function(pvc) {
		return data.entities.pvc;
	};

	self.getWan_vlan = function(wan_vlan) {
		return data.entities.wan_vlan;
	};

	self.getName = function() {
		if (data.entities.pvc != undefined) {
			return data.entities.pvc.getName();
		} else if (data.entities.wan_vlan != undefined) {
			return data.entities.wan_vlan.getName();
		} else {
			return "";
		}
	};

	self.getInstance = function() {
		return data.instance;
	};

	self.checkState = function() {
		data.isReady = true;

		$.each(data.entities, function(key, item) {
			if (!item.isReady()) {
				data.isReady = false;
				return;
			}
		});

		if (data.isReady) {
			$(self).trigger("ready");
		}
	};

	self.isReady = function() {
		return data.isReady;
	}

	globalModel.runWhenPossible(load);
}

function Pvc(instance) {
	var self = this;
	var data = {
		isReady : false,
		instance : instance,
		name : "",
	}

	function load() {
		globalModel.addGet({
			instance : data.instance,
			key : "name"
		});

		$(globalModel).bind("queryFinished", self.resumeLoad);

		globalModel.sendAjax();
	};

	self.resumeLoad = function(event, _data) {
		$(globalModel).off("queryFinished", self.resumeLoad);
		self.setName(_data[data.instance]["name"]);
		data.isReady = true;
		$(self).trigger("ready");
	}

	self.setName = function(name) {
		data.name = name;
	}

	self.getName = function(name) {
		return data.name;
	}

	self.isReady = function() {
		return data.isReady;
	}

	globalModel.runWhenPossible(load);
}

function Wan_vlan(instance) {
	var self = this;
	var data = {
		isReady : false,
		instance : instance,
		name : "",
	}

	function load() {
		globalModel.addGet({
			instance : data.instance,
			key : "name"
		});

		$(globalModel).bind("queryFinished", self.resumeLoad);

		globalModel.sendAjax();
	};

	self.resumeLoad = function(event, _data) {
		$(globalModel).off("queryFinished", self.resumeLoad);
		self.setName(_data[data.instance]["name"]);
		data.isReady = true;
		$(self).trigger("ready");
	}

	self.setName = function(name) {
		data.name = name;
	}

	self.getName = function(name) {
		return data.name;
	}

	self.isReady = function() {
		return data.isReady;
	}
	globalModel.runWhenPossible(load);
}