#!/bin/sh

cd /var

echo ===================
echo USB read/write test
echo ====================
mkdir usbstick
mknod sda1 b 8 1
mount -t vfat sda1 usbstick 
if [ "$?" != "0" ]; then 
	echo !!! mount failed !!!
	exit
fi
s1=$(date +%s)
a=1
while [ $a -le 1000 ]
do
echo read/write no = $a
cp /lib/libc.so.0 usbstick/
if [ "$?" != "0" ]; then
        echo !!! write failed !!!
        exit
fi
cp usbstick/libc.so.0 .
if [ "$?" != "0" ]; then
        echo !!! read failed !!!
        exit
fi
echo complete.
a=$((a+1))
done
s2=$(date +%s)
echo =========================
echo time elapsed = $(($s2 - $s1)) seconds
echo rate = $((2 * 312888 * 1000 / ($s2 - $s1))) bytes/sec
echo =========================
rm libc.so.0
umount usbstick
rm sda1
if [ "$?" != "0" ]; then
        echo !!! umount failed !!!
        exit
fi
rm -rf usbstick
echo =========================
echo    USB TEST SUCCESSFUL
echo =========================

