#!/bin/sh

#
# Author: Bayram Kurumahmut <bayram.kurumahmut@airties.com>
#

echo "*"
echo "* Managers: Instances"
echo "*"

manager_list=`cli query devmgr-0:mngr_list | cut -s -f3`

for manager in $manager_list
do
    echo -n "$manager:"
    instance_list=`cli query devmgr-0:inst_list $manager | cut -s -f3`
    for instance in $instance_list
    do
	echo -n " $instance"
    done
    echo ""
done

echo "*"
echo "* Instance: Requester and ref total list"
echo "*"

for manager in $manager_list
do
    instance_list=`cli query devmgr-0:inst_list $manager | cut -s -f3`
    for instance in $instance_list
    do
		req_resp=`cli query onlyresp cfgmgr-0:requester $instance`
		ref_total=`cli query onlyresp cfgmgr-0:ref_total $instance`
		last_action=`cli query onlyresp cfgmgr-0:last_action $instance`
		[ "$req_resp" != "no_requester" ] && {
			echo " $instance: $req_resp ($ref_total) [$last_action s]"
		} || {
			[ "$ref_total" != "0" ] && {
				echo " $instance: ($ref_total) [$last_action s]"
			}
		}
    done
done

echo "*"
echo "* Process list"
echo "*"
killall -USR2 pc
