#!/bin/sh

#
# Author: Bayram Kurumahmut <bayram.kurumahmut@airties.com>
#

echo "**************************************"
echo "* dsl_statistics.sh: cli query tests *"
echo "**************************************"

#
# Run query given in parameter
#
do_job()
{
    echo ""
    echo "* cli query dsl-0:$1"
    echo "*"
    cli query dsl-0:$1
}

#
# If there is a request, run only requested parameters
#
[ $# -gt 0 ] && {
    while [ $# -gt 0 ]
    do
	do_job $1
	shift
    done
    exit
}

#
# Run all parameters by default
#   NIT means 'Not in TR-098'. 
#     '_nit' list is not implemented.
#     '_nit_ok' list is implemented.
#   NUS means 'No utility support', not supported by driver.
#     '_nus' list is implemented.
#
param_list="HLINpsds HLOGpsds ModulationType BITSpsds DownstreamNoiseMargin SNRpsds ACTATPds ACTATPus \
UpstreamCurrRate DownstreamCurrRate UpstreamNoiseMargin UpstreamAttenuation DownstreamAttenuation DataPath \
LinkStatus CurrentDayCodingViolationsds CurrentDayCodingViolationsus LoopDownstreamAttenuation \
LoopUpstreamAttenuation QLNpsds DownstreamMaxRate LineActualDslStandard CurrentDayFECds HECErrors ATUCHECErrors \
CRCErrors ATUCCRCErrors ErroredSecs ATUCErroredSecs LossOfFraming SeverelyErroredSecs ReceiveBlocks \
TransmitBlocks GAINSpsds CellDelin FECErrors LineEncoding UpstreamPower DownstreamPower LineUpstreamAttenuation \
LineDownstreamAttenuation SignalUpstreamAttenuation SignalDownstreamAttenuation ShowtimeCRCErrors \
ShowtimeATUCCRCErrors ShowtimeFECErrors ShowtimeATUCFECErrors ShowtimeErroredSecs ShowtimeATUCErroredSecs \
ShowtimeSeverelyErroredSecs ShowtimeATUCSeverelyErroredSecs ShowtimeCellDelin ShowtimeInitErrors \
ShowtimeInitTimeouts ShowtimeLossOfFraming ShowtimeReceiveBlocks ShowtimeTransmitBlocks ATUCSeverelyErroredSecs \
InitErrors InitTimeouts"
param_list_nit="ConfigMode TargetNoiseMarginDownstream LatencyPathds SNRpsus TargetNoiseMarginUpstream \
QLNpsus XdslLineInmInterArrivalTimeOffset XdslLineInmEquivInpMode XdslFarEndLineInmInterArrivalTimeOffset \
XdslFarEndLineInmInterArrivalTimeStep XdslLineInmInterArrivalTimeStep XdslLineInmCurrent1DayIatHistogram \
XdslLineInmCurrent1DayEquivInpHistogram XdslLineInmCurrent1DayTotalDataSymbolCounter \
XdslFarEndLineInmCurrent1DayIatHistogram XdslFarEndLineInmCurrent1DayEquivInpHistogram \
XdslFarEndLineInmCurrent1DayTotalDataSymbolCounter XdslFarEndLineInmEquivInpMode"
param_list_nit_ok="MinImpulsNoiseProtectionus CurrentDayFECus MaxDelayus MinImpulsNoiseProtectionds MaxDelayds"
param_list_nus="ACTPSDds ACTPSDus LOF ShowtimeHECErrors ShowtimeATUCHECErrors ShowtimeLInit ShowtimeLOF \
LInit"

for cmd in `echo $param_list $param_list_nit_ok $param_list_nus`
do
    do_job $cmd
done
