#!/bin/sh

#
# debug.sh
#
#   Debug library. Include this script file from other script files.
#   Then set debug_level, and debug_owner accordingly. 
#
#   Find example in 'hotspot.sh'
#
# Copyright (C) 2013  Bayram Kurumahmut <bayram.kurumahmut@airties.com>
#

debug_level=1
debug_owner="debug.sh"
debug_logfile=
debug_logfile_linecount=1000

debug_log()
{
	[ -n "$debug_logfile" ] && {
		[ -f $debug_logfile ] && {
			line_count=`grep -c $ $debug_logfile`
			[ $line_count -gt $debug_logfile_linecount ] && {
				echo > $debug_logfile
			}
		}
		echo "$(date +%s) $1" >> $debug_logfile
	}
}

debug_print()
{
	echo "$(date +%s) $1"
	debug_log "$1"
}

debug_crazy()
{
	[ $debug_level -ge 5 ] && {
		debug_print "[$debug_owner] [CRAZY] $1"
	}
}

debug_trace()
{
	[ $debug_level -ge 4 ] && {
		debug_print "[$debug_owner] [TRACE] $1"
	}
}

debug_info()
{
	[ $debug_level -ge 3 ] && {
		debug_print "[$debug_owner] [INFO] $1"
	}
}

debug_warn()
{
	[ $debug_level -ge 2 ] && {
		debug_print "[$debug_owner] [WARN] $1"
	}
}

debug_error()
{
	[ $debug_level -ge 1 ] && {
		debug_print "[$debug_owner] [ERROR] $1"
	}
}
