#!/bin/sh

#
# config.sh
#
#   Config library
#
# Copyright (C) 2013  Bayram Kurumahmut <bayram.kurumahmut@airties.com>
#

resp_type=
try_val=

apply_list_file=/var/apply_list_task_ctrl

cli_set()
{
	debug_trace "cli set $resp_type $try_val requester $req_val $1"
	response=`cli set $resp_type $try_val requester $req_val $1`
	debug_trace "cli set $resp_type $try_val requester $req_val $1 => '$response'"
}

cli_get()
{
	debug_trace "cli get $resp_type $try_val requester $req_val $1"
	response=`cli get $resp_type $try_val requester $req_val $1`
	debug_trace "cli get $resp_type $try_val requester $req_val $1 => '$response'"
}

cli_cmd()
{
	debug_trace "cli command $resp_type $try_val requester $req_val $1"
	response=`cli command $resp_type $try_val requester $req_val $1`
	debug_trace "cli command $resp_type $try_val requester $req_val $1 => '$response'"
}

out_file=>> /dev/null

get_cfg_only()
{
	debug_log "cli get $resp_type $try_val requester $req_val $1:$2 $3"
	response=`cli get $resp_type $try_val requester $req_val $1:$2 $3`
	echo "$response"
	debug_log "cli get $resp_type $try_val requester $req_val $1:$2 $3 => '$response'"
}

get_cfg()
{
	cli command $resp_type $try_val requester $req_val cfgmgr-0:begin_transaction $1 $out_file
	response=`cli get $resp_type $try_val requester $req_val $1:$2 $3`
	cli command $resp_type $try_val requester $req_val cfgmgr-0:end_transaction $1 $out_file
	echo "$response"

	debug_log "cli command $resp_type $try_val requester $req_val cfgmgr-0:begin_transaction $1"
	debug_log "cli get $resp_type $try_val requester $req_val $1:$2 => '$response'"
	debug_log "cli command $resp_type $try_val requester $req_val cfgmgr-0:end_transaction $1"
}

set_cfg_only()
{
	debug_log "cli set $resp_type $try_val requester $req_val $1:$2 '$3'"
	response=`cli set $resp_type $try_val requester $req_val $1:$2 "$3"`
	echo "$response"
}

set_cfg()
{
	cli_cmd "cfgmgr-0:begin_transaction $1 $out_file"
	cli_set "$1:$2 $3"
	cli_cmd "cfgmgr-0:commit $1 $out_file"
	cli_cmd "cfgmgr-0:end_transaction $1 $out_file"
}

is_valid_inst()
{
	[ ! -n "$1" ] && {
		echo "0"
		return
	}

	# HACK: inst_list sometimes fails and we couldn't fix it
	echo "1"
	return

	ivi_inst=$1
	ivi_mngr=`echo ${ivi_inst%%-*}`

	isValid=`cli query $resp_type $try_val requester $req_val devmgr-0:inst_list_all $ivi_mngr | grep -c $ivi_inst`
	debug_log "$ivi_inst,$ivi_mngr - isValid:$isValid"
	[ "$isValid" = "0" ] && {
		echo "0"
		return
	}
	echo "1"
}
